/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.model.response.Namespace;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.console.handler.impl.inner.EnabledInnerHandler;
import com.alibaba.nacos.console.paramcheck.ConsoleDefaultHttpParamExtractor;
import com.alibaba.nacos.core.controller.compatibility.Compatibility;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.service.NamespaceOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/namespaces"})
@ExtractorManager.Extractor(httpExtractor=ConsoleDefaultHttpParamExtractor.class)
@EnabledInnerHandler
public class NamespaceController {
    @Autowired
    private NamespacePersistService namespacePersistService;
    @Autowired
    private NamespaceOperationService namespaceOperationService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private final Pattern namespaceNameCheckPattern = Pattern.compile("^[^@#$%^&*]+$");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    @GetMapping
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/core/namespace/list")
    public RestResult<List<Namespace>> getNamespaces() {
        return RestResultUtils.success((Object)this.namespaceOperationService.getNamespaceList());
    }

    @GetMapping(params={"show=all"})
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/core/namespace")
    public Namespace getNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return this.namespaceOperationService.getNamespace(namespaceId);
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="POST ${contextPath:nacos}/v3/console/core/namespace")
    public Boolean createNamespace(@RequestParam(value="customNamespaceId") String namespaceId, @RequestParam(value="namespaceName") String namespaceName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                return false;
            }
            if (namespaceId.length() > 128) {
                return false;
            }
            if (this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) > 0) {
                return false;
            }
        }
        if (!this.namespaceNameCheckPattern.matcher(namespaceName).matches()) {
            return false;
        }
        try {
            return this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc);
        }
        catch (NacosException e) {
            return false;
        }
    }

    @GetMapping(params={"checkNamespaceIdExist=true"})
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="GET ${contextPath:nacos}/v3/console/core/namespace/exist")
    public Boolean checkNamespaceIdExist(@RequestParam(value="customNamespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return false;
        }
        return this.namespacePersistService.tenantInfoCountByTenantId(namespaceId) > 0;
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="PUT ${contextPath:nacos}/v3/console/core/namespace")
    public Boolean editNamespace(@RequestParam(value="namespace") String namespace, @RequestParam(value="namespaceShowName") String namespaceShowName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        if (!this.namespaceNameCheckPattern.matcher(namespaceShowName).matches()) {
            return false;
        }
        return this.namespaceOperationService.editNamespace(namespace, namespaceShowName, namespaceDesc);
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    @Compatibility(apiType=ApiType.CONSOLE_API, alternatives="DELETE ${contextPath:nacos}/v3/console/core/namespace")
    public Boolean deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) {
        return this.namespaceOperationService.removeNamespace(namespaceId);
    }
}

