/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.config;

import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import com.alibaba.nacos.sys.env.EnvUtil;

public class NacosConsoleAuthConfig
extends AbstractDynamicConfig
implements NacosAuthConfig {
    public static final String NACOS_CONSOLE_AUTH_SCOPE = ApiType.CONSOLE_API.name();
    private boolean authEnabled;
    private String nacosAuthSystemType;
    private String serverIdentityKey;
    private String serverIdentityValue;

    public NacosConsoleAuthConfig() {
        super("NacosConsoleAuth");
        this.resetConfig();
    }

    public String getAuthScope() {
        return NACOS_CONSOLE_AUTH_SCOPE;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getNacosAuthSystemType() {
        return this.nacosAuthSystemType;
    }

    public boolean isSupportServerIdentity() {
        return StringUtils.isNotBlank((String)this.serverIdentityKey) && StringUtils.isNotBlank((String)this.serverIdentityValue);
    }

    public String getServerIdentityKey() {
        return this.serverIdentityKey;
    }

    public String getServerIdentityValue() {
        return this.serverIdentityValue;
    }

    protected void getConfigFromEnv() {
        this.authEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.core.auth.console.enabled", Boolean.class, (Object)true);
        this.nacosAuthSystemType = EnvUtil.getProperty((String)"nacos.core.auth.system.type", (String)"");
        this.serverIdentityKey = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.key", (String)"");
        this.serverIdentityValue = EnvUtil.getProperty((String)"nacos.core.auth.server.identity.value", (String)"");
    }

    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "NacosConsoleAuthConfig{authEnabled=" + this.authEnabled + ", nacosAuthSystemType='" + this.nacosAuthSystemType + "'}";
    }
}

