/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.listener;

import com.alibaba.nacos.api.config.model.ConfigListenerInfo;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.config.NacosAuthConfig;
import com.alibaba.nacos.auth.config.NacosAuthConfigHolder;
import com.alibaba.nacos.auth.util.AuthHeaderUtil;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.config.server.service.listener.ConfigListenerStateService;
import com.alibaba.nacos.config.server.service.notify.HttpClientManager;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.core.auth.NacosServerAuthConfig;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class RemoteConfigListenerStateServiceImpl
implements ConfigListenerStateService {
    private static final String CONFIG_LISTENER_STATE_URL = "/v3/admin/cs/config/listener";
    private final ServerMemberManager memberManager;
    private final ConfigListenerInfo emptyConfigListenerInfo;

    public RemoteConfigListenerStateServiceImpl(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
        this.emptyConfigListenerInfo = new ConfigListenerInfo();
        this.emptyConfigListenerInfo.setListenersStatus(Collections.emptyMap());
    }

    @Override
    public ConfigListenerInfo getListenerState(String dataId, String groupName, String namespaceId) {
        Query query = Query.newInstance().addParam("dataId", (Object)dataId).addParam("groupName", (Object)groupName).addParam("namespaceId", (Object)namespaceId).addParam("aggregation", (Object)false);
        Header header = this.buildHeader();
        ConfigListenerInfo result = new ConfigListenerInfo();
        result.setListenersStatus(new HashMap(16));
        result.setQueryType("config");
        for (Member each : this.memberManager.allMembersWithoutSelf()) {
            String url = this.getUrl(each.getAddress(), CONFIG_LISTENER_STATE_URL);
            ConfigListenerInfo oneNodeResult = this.invokeUrl(url, query, header);
            result.getListenersStatus().putAll(oneNodeResult.getListenersStatus());
        }
        return result;
    }

    @Override
    public ConfigListenerInfo getListenerStateByIp(String ip) {
        Query query = Query.newInstance().addParam("ip", (Object)ip).addParam("aggregation", (Object)false);
        Header header = this.buildHeader();
        ConfigListenerInfo result = new ConfigListenerInfo();
        result.setListenersStatus(new HashMap(16));
        result.setQueryType("ip");
        for (Member each : this.memberManager.allMembersWithoutSelf()) {
            String url = this.getUrl(each.getAddress(), "/v3/admin/cs/listener");
            ConfigListenerInfo oneNodeResult = this.invokeUrl(url, query, header);
            result.getListenersStatus().putAll(oneNodeResult.getListenersStatus());
        }
        return result;
    }

    private String getUrl(String ip, String relativePath) {
        return "http://" + ip + EnvUtil.getContextPath() + relativePath;
    }

    private Header buildHeader() {
        Header header = Header.newInstance();
        header.addParam("Accept-Charset", "UTF-8");
        NacosAuthConfig authConfig = NacosAuthConfigHolder.getInstance().getNacosAuthConfigByScope(NacosServerAuthConfig.NACOS_SERVER_AUTH_SCOPE);
        AuthHeaderUtil.addIdentityToHeader((Header)header, (NacosAuthConfig)authConfig);
        return header;
    }

    private ConfigListenerInfo invokeUrl(String url, Query query, Header header) {
        try {
            HttpRestResult restResult = HttpClientManager.getNacosRestTemplate().get(url, header, query, String.class);
            if (!restResult.ok()) {
                LogUtil.DEFAULT_LOG.warn("Invoke remote server config listener state by url {} failed with code {}, msg {}", new Object[]{url, restResult.getCode(), restResult.getMessage()});
                return this.emptyConfigListenerInfo;
            }
            Result result = (Result)JacksonUtils.toObj((String)((String)restResult.getData()), (TypeReference)new TypeReference<Result<ConfigListenerInfo>>(){});
            return (ConfigListenerInfo)result.getData();
        }
        catch (Exception e) {
            LogUtil.DEFAULT_LOG.error("Invoke remote server config listener by url {} failed :", (Object)url, (Object)e);
            return this.emptyConfigListenerInfo;
        }
    }
}

