/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.filter;

import com.alibaba.nacos.config.server.utils.LogUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

public class NacosWebFilter
implements Filter {
    private static String webRootPath;

    public static String rootPath() {
        return webRootPath;
    }

    public static void setWebRootPath(String path) {
        webRootPath = path;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext ctx = filterConfig.getServletContext();
        NacosWebFilter.setWebRootPath(ctx.getRealPath("/"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        try {
            chain.doFilter(request, response);
        }
        catch (ServletException | IOException ioe) {
            LogUtil.DEFAULT_LOG.debug("Filter catch exception, " + ioe.toString(), ioe);
            throw ioe;
        }
    }

    public void destroy() {
    }
}

