/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller.v3;

import com.alibaba.nacos.api.config.remote.response.ConfigQueryResponse;
import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.config.server.model.ConfigCacheGray;
import com.alibaba.nacos.config.server.model.form.ConfigFormV3;
import com.alibaba.nacos.config.server.paramcheck.ConfigDefaultHttpParamExtractor;
import com.alibaba.nacos.config.server.service.query.ConfigQueryChainService;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainRequest;
import com.alibaba.nacos.config.server.service.query.model.ConfigQueryChainResponse;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.core.context.RequestContext;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.constant.ApiType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v3/client/cs/config"})
@ExtractorManager.Extractor(httpExtractor=ConfigDefaultHttpParamExtractor.class)
public class ConfigOpenApiController {
    private final ConfigQueryChainService configQueryChainService;

    public ConfigOpenApiController(ConfigQueryChainService configQueryChainService) {
        this.configQueryChainService = configQueryChainService;
    }

    @GetMapping
    @TpsControl(pointName="ConfigQuery")
    @Secured(action=ActionTypes.READ, signType="config", apiType=ApiType.OPEN_API)
    public Result<ConfigQueryResponse> getConfig(ConfigFormV3 configForm) throws NacosApiException, UnsupportedEncodingException {
        configForm.validate();
        RequestContext requestContext = RequestContextHolder.getContext();
        String sourceIp = requestContext.getBasicContext().getAddressContext().getSourceIp();
        ConfigQueryChainRequest chainRequest = this.buildQueryChainRequest(configForm, sourceIp);
        ConfigQueryChainResponse chainResponse = this.configQueryChainService.handle(chainRequest);
        if (Objects.isNull(chainResponse.getContent())) {
            this.traceQuery(configForm, chainResponse, requestContext, sourceIp, "not-found");
            return Result.failure((ErrorCode)ErrorCode.RESOURCE_NOT_FOUND);
        }
        this.traceQuery(configForm, chainResponse, requestContext, sourceIp, "ok");
        return Result.success((Object)this.transferToResult(chainResponse));
    }

    private ConfigQueryChainRequest buildQueryChainRequest(ConfigFormV3 configForm, String sourceIp) {
        ConfigQueryChainRequest request = new ConfigQueryChainRequest();
        request.setTenant(configForm.getNamespaceId());
        request.setGroup(configForm.getGroup());
        request.setDataId(configForm.getDataId());
        HashMap<String, String> appLabels = new HashMap<String, String>(4);
        appLabels.put("ClientIp", sourceIp);
        request.setAppLabels(appLabels);
        return request;
    }

    private ConfigQueryResponse transferToResult(ConfigQueryChainResponse chainResponse) throws UnsupportedEncodingException {
        ConfigQueryResponse result = new ConfigQueryResponse();
        result.setMd5(chainResponse.getMd5());
        result.setEncryptedDataKey(chainResponse.getEncryptedDataKey());
        result.setContent(chainResponse.getContent());
        result.setContentType(chainResponse.getConfigType());
        result.setLastModified(chainResponse.getLastModified());
        if (chainResponse.getStatus() == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_GRAY) {
            if ("beta".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                result.setBeta(true);
            } else if ("tag".equals(chainResponse.getMatchedGray().getGrayRule().getType())) {
                result.setTag(URLEncoder.encode(chainResponse.getMatchedGray().getRawGrayRule(), "UTF-8"));
            }
        }
        return result;
    }

    private void traceQuery(ConfigFormV3 configForm, ConfigQueryChainResponse chainResponse, RequestContext requestContext, String sourceIp, String pullType) {
        long delayed = System.currentTimeMillis() - chainResponse.getLastModified();
        ConfigTraceService.logPullEvent(configForm.getDataId(), configForm.getGroup(), configForm.getNamespaceId(), requestContext.getBasicContext().getApp(), chainResponse.getLastModified(), this.resolvePullEventType(chainResponse), pullType, delayed, sourceIp, false, "http");
    }

    private String resolvePullEventType(ConfigQueryChainResponse chainResponse) {
        if (Objects.requireNonNull(chainResponse.getStatus()) == ConfigQueryChainResponse.ConfigQueryStatus.CONFIG_FOUND_GRAY) {
            ConfigCacheGray matchedGray = chainResponse.getMatchedGray();
            if (matchedGray != null) {
                return "pull-" + matchedGray.getGrayName();
            }
            return "pull";
        }
        return "pull";
    }
}

