/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.configuration;

import com.alibaba.nacos.config.server.filter.CircuitFilter;
import com.alibaba.nacos.config.server.filter.NacosWebFilter;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.web.NacosWebBean;
import com.alibaba.nacos.persistence.configuration.condition.ConditionDistributedEmbedStorage;
import jakarta.servlet.Filter;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@NacosWebBean
public class NacosConfigConfiguration {
    private final ControllerMethodsCache methodsCache;

    public NacosConfigConfiguration(ControllerMethodsCache methodsCache) {
        this.methodsCache = methodsCache;
    }

    @PostConstruct
    public void init() {
        this.methodsCache.initClassMethod("com.alibaba.nacos.config.server.controller");
    }

    @Bean
    @ConditionalOnProperty(name={"nacos.web.charset.filter"}, havingValue="nacos", matchIfMissing=true)
    public FilterRegistrationBean<NacosWebFilter> nacosWebFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.nacosWebFilter());
        registration.addUrlPatterns(new String[]{"/v1/cs/*"});
        registration.setName("nacosWebFilter");
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public NacosWebFilter nacosWebFilter() {
        return new NacosWebFilter();
    }

    @Conditional(value={ConditionDistributedEmbedStorage.class})
    @Bean
    public FilterRegistrationBean<CircuitFilter> transferToLeaderRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)this.transferToLeader());
        registration.addUrlPatterns(new String[]{"/v1/cs/*"});
        registration.setName("curcuitFilter");
        registration.setOrder(6);
        return registration;
    }

    @Conditional(value={ConditionDistributedEmbedStorage.class})
    @Bean
    public CircuitFilter transferToLeader() {
        return new CircuitFilter();
    }
}

