/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.configuration;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.sys.env.EnvUtil;

public class ConfigCommonConfig
extends AbstractDynamicConfig {
    private static final String CONFIG_COMMON = "ConfigCommon";
    private static final ConfigCommonConfig INSTANCE = new ConfigCommonConfig();
    private int maxPushRetryTimes = 50;
    private long pushTimeout = 3000L;
    private int batchSize = 20;
    private boolean derbyOpsEnabled = false;
    private int maxPatternCount = 20;
    private int maxMatchedConfigCount = 500;

    private ConfigCommonConfig() {
        super(CONFIG_COMMON);
        this.resetConfig();
    }

    public static ConfigCommonConfig getInstance() {
        return INSTANCE;
    }

    public int getMaxPushRetryTimes() {
        return this.maxPushRetryTimes;
    }

    public void setMaxPushRetryTimes(int maxPushRetryTimes) {
        this.maxPushRetryTimes = maxPushRetryTimes;
    }

    public long getPushTimeout() {
        return this.pushTimeout;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isDerbyOpsEnabled() {
        return this.derbyOpsEnabled;
    }

    public void setDerbyOpsEnabled(boolean derbyOpsEnabled) {
        this.derbyOpsEnabled = derbyOpsEnabled;
    }

    public int getMaxPatternCount() {
        return this.maxPatternCount;
    }

    public int getMaxMatchedConfigCount() {
        return this.maxMatchedConfigCount;
    }

    protected void getConfigFromEnv() {
        this.maxPushRetryTimes = (Integer)EnvUtil.getProperty((String)"nacos.config.push.maxRetryTime", Integer.class, (Object)50);
        this.pushTimeout = (Long)EnvUtil.getProperty((String)"nacos.config.push.timeout", Long.class, (Object)3000L);
        this.batchSize = (Integer)EnvUtil.getProperty((String)"nacos.config.push.batchSize", Integer.class, (Object)20);
        this.derbyOpsEnabled = (Boolean)EnvUtil.getProperty((String)"nacos.config.derby.ops.enabled", Boolean.class, (Object)false);
        this.maxPatternCount = (Integer)EnvUtil.getProperty((String)"nacos.config.fuzzy.watch.max.pattern.count", Integer.class, (Object)20);
        this.maxMatchedConfigCount = (Integer)EnvUtil.getProperty((String)"nacos.config.fuzzy.watch.max.pattern.match.config.count", Integer.class, (Object)500);
    }

    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "ConfigCommonConfig{maxPushRetryTimes=" + this.maxPushRetryTimes + ", derbyOpsEnabled=" + this.derbyOpsEnabled + "}";
    }
}

