/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.utils;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    private static final String[] DEFAULT_IP_HEADER = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};

    public static String getRealIP(String remoteAddr, Function<String, String> getHeader, String ... otherHeaderNames) {
        String header;
        String ip = null;
        List headers = Stream.concat(Stream.of(DEFAULT_IP_HEADER), Stream.of(otherHeaderNames == null ? new String[]{} : otherHeaderNames)).collect(Collectors.toList());
        Iterator iterator = headers.iterator();
        while (iterator.hasNext() && (ip = IpUtils.processIp(getHeader.apply(header = (String)iterator.next()))) == null) {
        }
        return ip == null ? IpUtils.processIp(remoteAddr) : ip;
    }

    public static String getIP(Function<String, String> getHeader) {
        return IpUtils.getRealIP("", getHeader, null);
    }

    private static String processIp(String ip) {
        if (ip != null) {
            if (IpUtils.isUnknown(ip = ip.trim())) {
                return null;
            }
            if (ip.contains(",")) {
                String[] ips;
                for (String subIp : ips = ip.split(",")) {
                    ip = IpUtils.processIp(subIp);
                    if (ip == null) continue;
                    return ip;
                }
            }
            return ip;
        }
        return null;
    }

    private static boolean isUnknown(String ip) {
        return StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip.trim());
    }
}

