/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.resource;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ssssssss.magicapi.core.resource.Resource;

public abstract class KeyValueResource
implements Resource {
    protected String separator;
    protected String path;
    protected KeyValueResource parent;
    protected boolean readonly = false;

    public KeyValueResource(String separator, String path, KeyValueResource parent) {
        this.separator = separator;
        this.path = path;
        this.parent = parent;
    }

    public KeyValueResource(String separator, String path, boolean readonly, KeyValueResource parent) {
        this.separator = separator;
        this.path = path;
        this.parent = parent;
        this.readonly = readonly;
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public boolean isDirectory() {
        return this.path.endsWith(this.separator);
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public final boolean renameTo(Resource resource) {
        if (this.readonly()) {
            return false;
        }
        if (resource.getAbsolutePath().equalsIgnoreCase(this.getAbsolutePath())) {
            return true;
        }
        if (!(resource instanceof KeyValueResource)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5c06" + this.getAbsolutePath() + "\u91cd\u547d\u540d\u4e3a:" + resource.getAbsolutePath());
        }
        KeyValueResource targetResource = (KeyValueResource)resource;
        if (resource.isDirectory()) {
            Set<String> oldKeys = this.keys();
            HashMap<String, String> mappings = new HashMap<String, String>(oldKeys.size());
            int keyLen = this.path.length();
            oldKeys.forEach(oldKey -> mappings.put((String)oldKey, targetResource.path + oldKey.substring(keyLen)));
            return this.renameTo(mappings);
        }
        return this.renameTo(Collections.singletonMap(this.path, targetResource.path));
    }

    @Override
    public boolean delete() {
        if (this.readonly()) {
            return false;
        }
        if (this.isDirectory()) {
            return this.keys().stream().allMatch(this::deleteByKey);
        }
        return this.deleteByKey(this.getAbsolutePath());
    }

    protected boolean deleteByKey(String key) {
        return false;
    }

    protected abstract boolean renameTo(Map<String, String> var1);

    @Override
    public String name() {
        int index;
        String name = this.path;
        if (this.isDirectory()) {
            name = this.path.substring(0, name.length() - 1);
        }
        return (index = name.lastIndexOf(this.separator)) > -1 ? name.substring(index + 1) : name;
    }

    @Override
    public Resource getResource(String name) {
        name = (String)(this.isDirectory() ? this.path : this.path + this.separator) + (String)name;
        return this.mappedFunction().apply((String)name);
    }

    @Override
    public Resource getDirectory(String name) {
        return this.getResource(name + this.separator);
    }

    @Override
    public boolean mkdir() {
        if (!this.isDirectory()) {
            this.path = this.path + this.separator;
        }
        return this.write("this is directory");
    }

    @Override
    public Resource parent() {
        return this.parent;
    }

    @Override
    public boolean write(byte[] bytes) {
        return !this.readonly() && this.write(new String(bytes, StandardCharsets.UTF_8));
    }

    @Override
    public List<Resource> resources() {
        return this.keys().stream().map(this.mappedFunction()).collect(Collectors.toList());
    }

    protected abstract Function<String, Resource> mappedFunction();

    protected abstract Set<String> keys();

    @Override
    public List<Resource> dirs() {
        return this.resources().stream().filter(Resource::isDirectory).collect(Collectors.toList());
    }

    @Override
    public List<Resource> files(String suffix) {
        return this.resources().stream().filter(it -> it.name().endsWith(suffix)).collect(Collectors.toList());
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public String getFilePath() {
        Resource parent = this.parent();
        while (parent.parent() != null) {
            parent = parent.parent();
        }
        String path = this.getAbsolutePath().replace(parent.getAbsolutePath(), "").replace("\\", "/").replace(this.separator, "/");
        return path.startsWith("/") ? path.substring(1) : path;
    }
}

