/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.resource;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.ssssssss.magicapi.core.resource.Resource;
import org.ssssssss.magicapi.utils.IoUtils;

public class FileResource
implements Resource {
    private final boolean readonly;
    protected File file;
    protected String rootPath;

    public FileResource(File file, boolean readonly, String rootPath) {
        this.file = file;
        this.readonly = readonly;
        this.rootPath = rootPath;
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean delete() {
        return !this.readonly() && IoUtils.delete(this.file);
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean mkdir() {
        return !this.readonly() && this.file.mkdirs();
    }

    @Override
    public byte[] read() {
        return IoUtils.bytes(this.file);
    }

    @Override
    public boolean renameTo(Resource resource) {
        File target;
        if (!this.readonly() && this.file.renameTo(target = ((FileResource)resource).file)) {
            this.file = target;
            return true;
        }
        return false;
    }

    @Override
    public Resource getResource(String name) {
        return new FileResource(new File(this.file, name), this.readonly, this.rootPath);
    }

    @Override
    public String name() {
        return this.file.getName();
    }

    @Override
    public List<Resource> resources() {
        File[] files = this.file.listFiles();
        return files == null ? Collections.emptyList() : Arrays.stream(files).map(it -> new FileResource((File)it, this.readonly, this.rootPath)).collect(Collectors.toList());
    }

    @Override
    public Resource parent() {
        return this.rootPath.equals(this.file.getAbsolutePath()) ? null : new FileResource(this.file.getParentFile(), this.readonly, this.rootPath);
    }

    @Override
    public List<Resource> dirs() {
        return IoUtils.dirs(this.file).stream().map(it -> new FileResource((File)it, this.readonly, this.rootPath)).collect(Collectors.toList());
    }

    @Override
    public boolean write(byte[] bytes) {
        return !this.readonly() && IoUtils.write(this.file, bytes);
    }

    @Override
    public boolean write(String content) {
        return !this.readonly() && IoUtils.write(this.file, content);
    }

    @Override
    public List<Resource> files(String suffix) {
        return IoUtils.files(this.file, suffix).stream().map(it -> new FileResource((File)it, this.readonly, this.rootPath)).collect(Collectors.toList());
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String toString() {
        return String.format("file://%s", this.file.getAbsolutePath());
    }

    @Override
    public void processExport(ZipOutputStream zos, String path, Resource directory, List<Resource> resources, List<String> excludes) throws IOException {
        for (Resource resource : resources) {
            if (!resource.parent().getAbsolutePath().equals(directory.getAbsolutePath()) || excludes.contains(resource.name())) continue;
            if (resource.isDirectory()) {
                String newPath = path + resource.name() + "/";
                zos.putNextEntry(new ZipEntry(newPath));
                zos.closeEntry();
                this.processExport(zos, newPath, resource, resource.resources(), excludes);
                continue;
            }
            zos.putNextEntry(new ZipEntry(path + resource.name()));
            zos.write(resource.read());
            zos.closeEntry();
        }
    }

    @Override
    public String getFilePath() {
        Resource parent = this.parent();
        while (parent.parent() != null) {
            parent = parent.parent();
        }
        Object path = this.getAbsolutePath().replace(parent.getAbsolutePath(), "").replace("\\", "/");
        if (this.isDirectory() && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return ((String)path).startsWith("/") ? ((String)path).substring(1) : path;
    }
}

