/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.backup.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.ssssssss.magicapi.backup.model.Backup;
import org.ssssssss.magicapi.backup.service.MagicBackupService;
import org.ssssssss.magicapi.core.config.MagicConfiguration;
import org.ssssssss.magicapi.core.model.Group;
import org.ssssssss.magicapi.core.model.JsonBean;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.service.MagicDynamicRegistry;
import org.ssssssss.magicapi.core.web.MagicController;
import org.ssssssss.magicapi.core.web.MagicExceptionHandler;
import org.ssssssss.magicapi.utils.JsonUtils;
import org.ssssssss.magicapi.utils.WebUtils;

public class MagicBackupController
extends MagicController
implements MagicExceptionHandler {
    private final MagicBackupService service;

    public MagicBackupController(MagicConfiguration configuration) {
        super(configuration);
        this.service = configuration.getMagicBackupService();
    }

    @GetMapping(value={"/backups"})
    @ResponseBody
    public JsonBean<List<Backup>> backups(Long timestamp) {
        if (this.service == null) {
            return new JsonBean<List<Backup>>(Collections.emptyList());
        }
        return new JsonBean<List<Backup>>(this.service.backupList(timestamp == null ? System.currentTimeMillis() : timestamp));
    }

    @GetMapping(value={"/backup/{id}"})
    @ResponseBody
    public JsonBean<List<Backup>> backups(@PathVariable(value="id") String id) {
        if (this.service == null || StringUtils.isBlank((CharSequence)id)) {
            return new JsonBean<List<Backup>>(Collections.emptyList());
        }
        return new JsonBean<List<Backup>>(this.service.backupById(id));
    }

    @GetMapping(value={"/backup/rollback"})
    @ResponseBody
    public JsonBean<Boolean> rollback(String id, Long timestamp) throws IOException {
        this.notNull(this.service, BACKUP_NOT_ENABLED);
        Backup backup = this.service.backupInfo(id, timestamp);
        if ("full".equals(id)) {
            this.service.doBackupAll("\u8fd8\u539f\u5168\u91cf\u5907\u4efd\u524d\uff0c\u7cfb\u7edf\u81ea\u52a8\u5168\u91cf\u5907\u4efd", WebUtils.currentUserName());
            this.configuration.getMagicAPIService().upload(new ByteArrayInputStream(backup.getContent()), "full");
            return new JsonBean<Boolean>(true);
        }
        if (backup.getType().endsWith("-group")) {
            Group group = JsonUtils.readValue(backup.getContent(), Group.class);
            return new JsonBean<Boolean>(MagicConfiguration.getMagicResourceService().saveGroup(group));
        }
        MagicEntity entity = this.configuration.getMagicDynamicRegistries().stream().map(MagicDynamicRegistry::getMagicResourceStorage).filter(it -> it.folder().equals(backup.getType())).map(it -> it.read(backup.getContent())).findFirst().orElse(null);
        if (entity != null) {
            return new JsonBean<Boolean>(MagicConfiguration.getMagicResourceService().saveFile(entity));
        }
        return new JsonBean<Boolean>(false);
    }

    @GetMapping(value={"/backup"})
    @ResponseBody
    public JsonBean<String> backup(Long timestamp, String id) {
        this.notNull(this.service, BACKUP_NOT_ENABLED);
        this.notBlank(id, PARAMETER_INVALID);
        this.notNull(timestamp, PARAMETER_INVALID);
        Backup backup = this.service.backupInfo(id, timestamp);
        MagicEntity entity = JsonUtils.readValue(backup.getContent(), MagicEntity.class);
        return new JsonBean<String>(entity == null ? null : entity.getScript());
    }

    @PostMapping(value={"/backup/full"})
    @ResponseBody
    public JsonBean<Boolean> doBackup() throws IOException {
        this.notNull(this.service, BACKUP_NOT_ENABLED);
        this.service.doBackupAll("\u4e3b\u52a8\u5168\u91cf\u5907\u4efd", WebUtils.currentUserName());
        return new JsonBean<Boolean>(true);
    }
}

