/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.aop;

import com.mzt.logapi.beans.CodeVariableType;
import com.mzt.logapi.beans.LogRecord;
import com.mzt.logapi.beans.LogRecordOps;
import com.mzt.logapi.beans.MethodExecuteResult;
import com.mzt.logapi.context.LogRecordContext;
import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.service.ILogRecordPerformanceMonitor;
import com.mzt.logapi.service.ILogRecordService;
import com.mzt.logapi.service.IOperatorGetService;
import com.mzt.logapi.service.impl.DiffParseFunction;
import com.mzt.logapi.starter.support.aop.LogRecordOperationSource;
import com.mzt.logapi.starter.support.parse.LogFunctionParser;
import com.mzt.logapi.starter.support.parse.LogRecordValueParser;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

public class LogRecordInterceptor
extends LogRecordValueParser
implements MethodInterceptor,
Serializable,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(LogRecordInterceptor.class);
    private LogRecordOperationSource logRecordOperationSource;
    private String tenantId;
    private ILogRecordService bizLogService;
    private IOperatorGetService operatorGetService;
    private ILogRecordPerformanceMonitor logRecordPerformanceMonitor;
    private boolean joinTransaction;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        return this.execute(invocation, invocation.getThis(), method, invocation.getArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute(MethodInvocation invoker, Object target, Method method, Object[] args) throws Throwable {
        if (AopUtils.isAopProxy((Object)target)) {
            return invoker.proceed();
        }
        StopWatch stopWatch = new StopWatch("log-record-performance");
        stopWatch.start("before-execute");
        Class<?> targetClass = this.getTargetClass(target);
        Object ret = null;
        MethodExecuteResult methodExecuteResult = new MethodExecuteResult(method, args, targetClass);
        LogRecordContext.putEmptySpan();
        ArrayList<LogRecordOps> operations = new ArrayList();
        HashMap<String, String> functionNameAndReturnMap = new HashMap();
        try {
            operations = this.logRecordOperationSource.computeLogRecordOperations(method, targetClass);
            List<String> spElTemplates = this.getBeforeExecuteFunctionTemplate(operations);
            functionNameAndReturnMap = this.processBeforeExecuteFunctionTemplate(spElTemplates, targetClass, method, args);
        }
        catch (Exception e) {
            log.error("log record parse before function exception", (Throwable)e);
        }
        finally {
            stopWatch.stop();
        }
        try {
            ret = invoker.proceed();
            methodExecuteResult.setResult(ret);
            methodExecuteResult.setSuccess(true);
        }
        catch (Exception e) {
            methodExecuteResult.setSuccess(false);
            methodExecuteResult.setThrowable(e);
            methodExecuteResult.setErrorMsg(e.getMessage());
        }
        stopWatch.start("after-execute");
        try {
            if (!CollectionUtils.isEmpty(operations)) {
                this.recordExecute(methodExecuteResult, functionNameAndReturnMap, operations);
            }
        }
        catch (Exception t) {
            log.error("log record parse exception", (Throwable)t);
            throw t;
        }
        finally {
            LogRecordContext.clear();
            stopWatch.stop();
            try {
                this.logRecordPerformanceMonitor.print(stopWatch);
            }
            catch (Exception e) {
                log.error("execute exception", (Throwable)e);
            }
        }
        if (methodExecuteResult.getThrowable() != null) {
            throw methodExecuteResult.getThrowable();
        }
        return ret;
    }

    private List<String> getBeforeExecuteFunctionTemplate(Collection<LogRecordOps> operations) {
        ArrayList<String> spElTemplates = new ArrayList<String>();
        for (LogRecordOps operation : operations) {
            List<String> templates = this.getSpElTemplates(operation, operation.getSuccessLogTemplate());
            if (CollectionUtils.isEmpty(templates)) continue;
            spElTemplates.addAll(templates);
        }
        return spElTemplates;
    }

    private void recordExecute(MethodExecuteResult methodExecuteResult, Map<String, String> functionNameAndReturnMap, Collection<LogRecordOps> operations) {
        for (LogRecordOps operation : operations) {
            try {
                if (StringUtils.isEmpty((Object)operation.getSuccessLogTemplate()) && StringUtils.isEmpty((Object)operation.getFailLogTemplate()) || this.exitsCondition(methodExecuteResult, functionNameAndReturnMap, operation)) continue;
                if (!methodExecuteResult.isSuccess()) {
                    this.failRecordExecute(methodExecuteResult, functionNameAndReturnMap, operation);
                    continue;
                }
                this.successRecordExecute(methodExecuteResult, functionNameAndReturnMap, operation);
            }
            catch (Exception t) {
                log.error("log record execute exception", (Throwable)t);
                if (!this.joinTransaction) continue;
                throw t;
            }
        }
    }

    private void successRecordExecute(MethodExecuteResult methodExecuteResult, Map<String, String> functionNameAndReturnMap, LogRecordOps operation) {
        String action = "";
        boolean flag = true;
        if (!StringUtils.isEmpty((Object)operation.getIsSuccess())) {
            String condition = this.singleProcessTemplate(methodExecuteResult, operation.getIsSuccess(), functionNameAndReturnMap);
            if (StringUtils.endsWithIgnoreCase((String)condition, (String)"true")) {
                action = operation.getSuccessLogTemplate();
            } else {
                action = operation.getFailLogTemplate();
                flag = false;
            }
        } else {
            action = operation.getSuccessLogTemplate();
        }
        if (StringUtils.isEmpty((Object)action)) {
            return;
        }
        List<String> spElTemplates = this.getSpElTemplates(operation, action);
        String operatorIdFromService = this.getOperatorIdFromServiceAndPutTemplate(operation, spElTemplates);
        Map<String, String> expressionValues = this.processTemplate(spElTemplates, methodExecuteResult, functionNameAndReturnMap);
        this.saveLog(methodExecuteResult.getMethod(), !flag, operation, operatorIdFromService, action, expressionValues);
    }

    private void failRecordExecute(MethodExecuteResult methodExecuteResult, Map<String, String> functionNameAndReturnMap, LogRecordOps operation) {
        if (StringUtils.isEmpty((Object)operation.getFailLogTemplate())) {
            return;
        }
        String action = operation.getFailLogTemplate();
        List<String> spElTemplates = this.getSpElTemplates(operation, action);
        String operatorIdFromService = this.getOperatorIdFromServiceAndPutTemplate(operation, spElTemplates);
        Map<String, String> expressionValues = this.processTemplate(spElTemplates, methodExecuteResult, functionNameAndReturnMap);
        this.saveLog(methodExecuteResult.getMethod(), true, operation, operatorIdFromService, action, expressionValues);
    }

    private boolean exitsCondition(MethodExecuteResult methodExecuteResult, Map<String, String> functionNameAndReturnMap, LogRecordOps operation) {
        String condition;
        return !StringUtils.isEmpty((Object)operation.getCondition()) && StringUtils.endsWithIgnoreCase((String)(condition = this.singleProcessTemplate(methodExecuteResult, operation.getCondition(), functionNameAndReturnMap)), (String)"false");
    }

    private void saveLog(Method method, boolean flag, LogRecordOps operation, String operatorIdFromService, String action, Map<String, String> expressionValues) {
        if (StringUtils.isEmpty((Object)expressionValues.get(action)) || !this.diffLog && action.contains("#") && Objects.equals(action, expressionValues.get(action))) {
            return;
        }
        LogRecord logRecord = LogRecord.builder().tenant(this.tenantId).type(expressionValues.get(operation.getType())).bizNo(expressionValues.get(operation.getBizNo())).operator(this.getRealOperatorId(operation, operatorIdFromService, expressionValues)).subType(expressionValues.get(operation.getSubType())).extra(expressionValues.get(operation.getExtra())).codeVariable(this.getCodeVariable(method)).action(expressionValues.get(action)).fail(flag).createTime(new Date()).build();
        this.bizLogService.record(logRecord);
    }

    private Map<CodeVariableType, Object> getCodeVariable(Method method) {
        HashMap<CodeVariableType, Object> map = new HashMap<CodeVariableType, Object>();
        map.put(CodeVariableType.ClassName, method.getDeclaringClass());
        map.put(CodeVariableType.MethodName, method.getName());
        return map;
    }

    private List<String> getSpElTemplates(LogRecordOps operation, String ... actions) {
        ArrayList<String> spElTemplates = new ArrayList<String>();
        spElTemplates.add(operation.getType());
        spElTemplates.add(operation.getBizNo());
        spElTemplates.add(operation.getSubType());
        spElTemplates.add(operation.getExtra());
        spElTemplates.addAll(Arrays.asList(actions));
        return spElTemplates;
    }

    private String getRealOperatorId(LogRecordOps operation, String operatorIdFromService, Map<String, String> expressionValues) {
        return !StringUtils.isEmpty((Object)operatorIdFromService) ? operatorIdFromService : expressionValues.get(operation.getOperatorId());
    }

    private String getOperatorIdFromServiceAndPutTemplate(LogRecordOps operation, List<String> spElTemplates) {
        String realOperatorId = "";
        if (StringUtils.isEmpty((Object)operation.getOperatorId())) {
            realOperatorId = this.operatorGetService.getUser().getOperatorId();
            if (StringUtils.isEmpty((Object)realOperatorId)) {
                throw new IllegalArgumentException("[LogRecord] operator is null");
            }
        } else {
            spElTemplates.add(operation.getOperatorId());
        }
        return realOperatorId;
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    public void setLogRecordOperationSource(LogRecordOperationSource logRecordOperationSource) {
        this.logRecordOperationSource = logRecordOperationSource;
    }

    public void setTenant(String tenant) {
        this.tenantId = tenant;
    }

    public void setLogRecordService(ILogRecordService bizLogService) {
        this.bizLogService = bizLogService;
    }

    public void setLogRecordPerformanceMonitor(ILogRecordPerformanceMonitor logRecordPerformanceMonitor) {
        this.logRecordPerformanceMonitor = logRecordPerformanceMonitor;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public void setDiffLog(boolean diffLog) {
        this.diffLog = diffLog;
    }

    public void afterSingletonsInstantiated() {
        this.bizLogService = (ILogRecordService)this.beanFactory.getBean(ILogRecordService.class);
        this.operatorGetService = (IOperatorGetService)this.beanFactory.getBean(IOperatorGetService.class);
        this.setLogFunctionParser(new LogFunctionParser((IFunctionService)this.beanFactory.getBean(IFunctionService.class)));
        this.setDiffParseFunction((DiffParseFunction)this.beanFactory.getBean(DiffParseFunction.class));
    }
}

