/*
 * Decompiled with CFR 0.152.
 */
package io.github.imfangs.dify.client.model.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import lombok.Generated;

public class FilePreviewResponse
implements AutoCloseable {
    private InputStream inputStream;
    private Long contentLength;
    private String contentType;
    private Boolean isAttachment;
    private String fileName;
    private Map<String, String> headers;
    private Boolean acceptRanges;
    private String cacheControl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContentAsBytes() throws IOException {
        if (this.inputStream == null) {
            return null;
        }
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((nRead = this.inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            this.inputStream.close();
        }
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Generated
    public static FilePreviewResponseBuilder builder() {
        return new FilePreviewResponseBuilder();
    }

    @Generated
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Generated
    public Long getContentLength() {
        return this.contentLength;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public Boolean getIsAttachment() {
        return this.isAttachment;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public Boolean getAcceptRanges() {
        return this.acceptRanges;
    }

    @Generated
    public String getCacheControl() {
        return this.cacheControl;
    }

    @Generated
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Generated
    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    @Generated
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setIsAttachment(Boolean isAttachment) {
        this.isAttachment = isAttachment;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Generated
    public void setAcceptRanges(Boolean acceptRanges) {
        this.acceptRanges = acceptRanges;
    }

    @Generated
    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilePreviewResponse)) {
            return false;
        }
        FilePreviewResponse other = (FilePreviewResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$contentLength = this.getContentLength();
        Long other$contentLength = other.getContentLength();
        if (this$contentLength == null ? other$contentLength != null : !((Object)this$contentLength).equals(other$contentLength)) {
            return false;
        }
        Boolean this$isAttachment = this.getIsAttachment();
        Boolean other$isAttachment = other.getIsAttachment();
        if (this$isAttachment == null ? other$isAttachment != null : !((Object)this$isAttachment).equals(other$isAttachment)) {
            return false;
        }
        Boolean this$acceptRanges = this.getAcceptRanges();
        Boolean other$acceptRanges = other.getAcceptRanges();
        if (this$acceptRanges == null ? other$acceptRanges != null : !((Object)this$acceptRanges).equals(other$acceptRanges)) {
            return false;
        }
        InputStream this$inputStream = this.getInputStream();
        InputStream other$inputStream = other.getInputStream();
        if (this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$cacheControl = this.getCacheControl();
        String other$cacheControl = other.getCacheControl();
        return !(this$cacheControl == null ? other$cacheControl != null : !this$cacheControl.equals(other$cacheControl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilePreviewResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $contentLength = this.getContentLength();
        result = result * 59 + ($contentLength == null ? 43 : ((Object)$contentLength).hashCode());
        Boolean $isAttachment = this.getIsAttachment();
        result = result * 59 + ($isAttachment == null ? 43 : ((Object)$isAttachment).hashCode());
        Boolean $acceptRanges = this.getAcceptRanges();
        result = result * 59 + ($acceptRanges == null ? 43 : ((Object)$acceptRanges).hashCode());
        InputStream $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $cacheControl = this.getCacheControl();
        result = result * 59 + ($cacheControl == null ? 43 : $cacheControl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FilePreviewResponse(inputStream=" + this.getInputStream() + ", contentLength=" + this.getContentLength() + ", contentType=" + this.getContentType() + ", isAttachment=" + this.getIsAttachment() + ", fileName=" + this.getFileName() + ", headers=" + this.getHeaders() + ", acceptRanges=" + this.getAcceptRanges() + ", cacheControl=" + this.getCacheControl() + ")";
    }

    @Generated
    public FilePreviewResponse() {
    }

    @Generated
    public FilePreviewResponse(InputStream inputStream, Long contentLength, String contentType, Boolean isAttachment, String fileName, Map<String, String> headers, Boolean acceptRanges, String cacheControl) {
        this.inputStream = inputStream;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.isAttachment = isAttachment;
        this.fileName = fileName;
        this.headers = headers;
        this.acceptRanges = acceptRanges;
        this.cacheControl = cacheControl;
    }

    @Generated
    public static class FilePreviewResponseBuilder {
        @Generated
        private InputStream inputStream;
        @Generated
        private Long contentLength;
        @Generated
        private String contentType;
        @Generated
        private Boolean isAttachment;
        @Generated
        private String fileName;
        @Generated
        private Map<String, String> headers;
        @Generated
        private Boolean acceptRanges;
        @Generated
        private String cacheControl;

        @Generated
        FilePreviewResponseBuilder() {
        }

        @Generated
        public FilePreviewResponseBuilder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder isAttachment(Boolean isAttachment) {
            this.isAttachment = isAttachment;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder acceptRanges(Boolean acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        @Generated
        public FilePreviewResponseBuilder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @Generated
        public FilePreviewResponse build() {
            return new FilePreviewResponse(this.inputStream, this.contentLength, this.contentType, this.isAttachment, this.fileName, this.headers, this.acceptRanges, this.cacheControl);
        }

        @Generated
        public String toString() {
            return "FilePreviewResponse.FilePreviewResponseBuilder(inputStream=" + this.inputStream + ", contentLength=" + this.contentLength + ", contentType=" + this.contentType + ", isAttachment=" + this.isAttachment + ", fileName=" + this.fileName + ", headers=" + this.headers + ", acceptRanges=" + this.acceptRanges + ", cacheControl=" + this.cacheControl + ")";
        }
    }
}

