/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.excel.adapter.easyexcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.gongbo.excel.adapter.easyexcel.converter.ExcelValue;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class DefaultEnumConvert
implements Converter<Object> {
    public Class supportJavaTypeKey() {
        return Object.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Object convertToJavaData(ReadCellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String stringValue = Optional.ofNullable(cellData.getStringValue()).map(String::trim).orElse("");
        Class<?> type = excelContentProperty.getField().getType();
        Field field = Arrays.stream(type.getDeclaredFields()).filter(f -> {
            ExcelValue excelValue = f.getAnnotation(ExcelValue.class);
            if (excelValue == null) {
                return false;
            }
            return excelValue.value() == ExcelValue.Support.READ || excelValue.value() == ExcelValue.Support.ALL;
        }).findAny().orElseThrow(() -> new IllegalArgumentException("\u5728\u679a\u4e3e\u7c7b\u4e0a\u6ca1\u6709\u627e\u5230\u652f\u6301\u8f93\u5165\u7684ExcelValue\u6ce8\u89e3"));
        field.setAccessible(true);
        for (Object enumConstant : type.getEnumConstants()) {
            Object value = field.get(enumConstant);
            if (!Objects.equals(String.valueOf(value), stringValue)) continue;
            return enumConstant;
        }
        throw new IllegalStateException("\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\uff1a" + stringValue);
    }

    public WriteCellData convertToExcelData(Object o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        Class<?> type = excelContentProperty.getField().getType();
        Field[] declaredFields = type.getDeclaredFields();
        Field field = Arrays.stream(declaredFields).filter(f -> {
            ExcelValue excelValue = f.getAnnotation(ExcelValue.class);
            if (excelValue == null) {
                return false;
            }
            return excelValue.value() == ExcelValue.Support.WRITE || excelValue.value() == ExcelValue.Support.ALL;
        }).findAny().orElseThrow(() -> new IllegalArgumentException("\u5728\u679a\u4e3e\u7c7b\u4e0a\u6ca1\u6709\u627e\u5230\u652f\u6301\u8f93\u51fa\u7684ExcelValue\u6ce8\u89e3"));
        field.setAccessible(true);
        Object value = field.get(o);
        return new WriteCellData(String.valueOf(value));
    }
}

