/*
 * Decompiled with CFR 0.152.
 */
package com.gongbo.excel.adapter.easyexcel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.gongbo.excel.adapter.easyexcel.ImportReadListener;
import com.gongbo.excel.adapter.easyexcel.overides.ExcelWriteFillExecutor;
import com.gongbo.excel.common.enums.ExcelType;
import com.gongbo.excel.common.utils.CollectionUtil;
import com.gongbo.excel.common.utils.ReflectUtil;
import com.gongbo.excel.common.utils.StringUtil;
import com.gongbo.excel.export.adapter.ExportAdapter;
import com.gongbo.excel.export.entity.ExportContext;
import com.gongbo.excel.export.entity.ExportFieldInfo;
import com.gongbo.excel.export.entity.ExportFillData;
import com.gongbo.excel.export.exception.FillKeyNotFoundException;
import com.gongbo.excel.imports.adapter.ImportAdapter;
import com.gongbo.excel.imports.entity.ImportContext;
import com.gongbo.excel.imports.utils.ImportUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class EasyExcelAdapter
implements ExportAdapter,
ImportAdapter {
    public String name() {
        return "easy_excel";
    }

    private ExcelTypeEnum convert(ExcelType excelType) {
        if (excelType.getValue().equals(ExcelTypeEnum.XLS.getValue())) {
            return ExcelTypeEnum.XLS;
        }
        if (excelType.getValue().equals(ExcelTypeEnum.XLSX.getValue())) {
            return ExcelTypeEnum.XLSX;
        }
        throw new IllegalArgumentException();
    }

    public Collection<?> read(ImportContext importContext, InputStream inputStream) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        Collection container = ImportUtils.buildCollectionContainer((Class)importContext.getTargetArgumentContainerClass());
        CompletableFuture completableFuture = new CompletableFuture();
        ImportReadListener readListener = new ImportReadListener(container, (data, analysisContext) -> completableFuture.complete(data), (exception, analysisContext) -> completableFuture.completeExceptionally((Throwable)exception));
        Class modelClass = importContext.getTargetArgumentClass();
        ExcelReaderBuilder readerBuilder = EasyExcelFactory.read((InputStream)inputStream, (Class)modelClass, (ReadListener)readListener);
        ExcelReaderSheetBuilder excelReaderSheetBuilder = importContext.getSheetNo() != null && importContext.getSheetNo() >= 0 ? readerBuilder.sheet(importContext.getSheetNo()) : (StringUtil.isNotEmpty((String)importContext.getSheetName()) ? readerBuilder.sheet(importContext.getSheetName()) : readerBuilder.sheet(Integer.valueOf(0)));
        excelReaderSheetBuilder.doRead();
        Integer readTimeout = importContext.getImportProperties().getReadTimeout();
        if (readTimeout == null || readTimeout <= 0) {
            return (Collection)completableFuture.get();
        }
        return (Collection)completableFuture.get(readTimeout.intValue(), TimeUnit.MILLISECONDS);
    }

    public void responseTemplate(ImportContext importContext, OutputStream outputStream) throws IOException {
        ExcelWriterBuilder excelWriterBuilder = EasyExcelFactory.write((OutputStream)outputStream, (Class)importContext.getTargetArgumentClass());
        excelWriterBuilder.sheet(importContext.getSheetNo(), importContext.getSheetName()).doWrite((Collection)null);
    }

    public void export(ExportContext exportContext, List<?> data, OutputStream outputStream) throws IOException {
        if (data == null) {
            data = Collections.emptyList();
        }
        ExcelWriterBuilder excelWriterBuilder = EasyExcelFactory.write((OutputStream)outputStream, (Class)exportContext.getModel());
        if (CollectionUtil.isNotEmpty((Collection)exportContext.getFieldInfos())) {
            Set includeColumns = exportContext.getFieldInfos().stream().map(ExportFieldInfo::getFieldName).collect(Collectors.toSet());
            excelWriterBuilder = (ExcelWriterBuilder)excelWriterBuilder.includeColumnFiledNames(includeColumns);
        }
        excelWriterBuilder = excelWriterBuilder.excelType(this.convert(exportContext.getExcelType()));
        ExcelWriterSheetBuilder excelWriterSheetBuilder = excelWriterBuilder.sheet(StringUtil.firstNotEmpty((String[])new String[]{exportContext.getSheetName(), exportContext.getExportProperties().getDefaultSheetName()}));
        excelWriterSheetBuilder.doWrite(data);
    }

    public void export(ExportContext exportContext, InputStream templateInputStream, List<?> data, OutputStream outputStream) {
        if (data == null) {
            data = Collections.emptyList();
        }
        ExcelWriterBuilder excelWriterBuilder = EasyExcelFactory.write((OutputStream)outputStream, (Class)exportContext.getModel());
        excelWriterBuilder = excelWriterBuilder.withTemplate(templateInputStream);
        if (CollectionUtil.isNotEmpty((Collection)exportContext.getFieldInfos())) {
            Set includeColumns = exportContext.getFieldInfos().stream().map(ExportFieldInfo::getFieldName).collect(Collectors.toSet());
            excelWriterBuilder = (ExcelWriterBuilder)excelWriterBuilder.includeColumnFiledNames(includeColumns);
        }
        excelWriterBuilder = excelWriterBuilder.excelType(this.convert(exportContext.getExcelType()));
        ExcelWriter excelWriter = excelWriterBuilder.build();
        List exportFillDataList = exportContext.listExportFillData();
        boolean dataFillFlag = CollectionUtil.isNotEmpty(data);
        if (dataFillFlag) {
            for (Object item : data) {
                if (!(item instanceof ExportFillData)) continue;
                exportFillDataList.add((ExportFillData)item);
                dataFillFlag = false;
            }
        }
        ExcelWriteFillExecutor excelWriteFillExecutor = new ExcelWriteFillExecutor(excelWriter.writeContext());
        if (dataFillFlag) {
            WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetName(StringUtil.firstNotEmpty((String[])new String[]{exportContext.getSheetName(), exportContext.getExportProperties().getDefaultSheetName()})).build();
            this.fill(excelWriter.writeContext(), excelWriteFillExecutor, data, null, writeSheet, false);
        }
        for (ExportFillData exportFillData : exportFillDataList) {
            if (exportFillData.isFillAllSheet()) {
                int numberOfSheets = excelWriter.writeContext().writeWorkbookHolder().getWorkbook().getNumberOfSheets();
                for (int sheetNo = 0; sheetNo < numberOfSheets; ++sheetNo) {
                    WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetNo(Integer.valueOf(sheetNo)).build();
                    this.fill(excelWriter.writeContext(), excelWriteFillExecutor, exportFillData.getData(), (FillConfig)exportFillData.getFillConfig(), writeSheet, true);
                }
                continue;
            }
            WriteSheet writeSheet = new ExcelWriterSheetBuilder(excelWriter).sheetNo(exportFillData.getSheetNo()).sheetName(exportFillData.getSheetName()).build();
            this.fill(excelWriter.writeContext(), excelWriteFillExecutor, exportFillData.getData(), (FillConfig)exportFillData.getFillConfig(), writeSheet, false);
        }
        if (exportContext.isFormula()) {
            this.doFormula(exportContext, excelWriter.writeContext().writeWorkbookHolder().getWorkbook());
        }
        excelWriter.finish();
    }

    private void doFormula(ExportContext exportContext, Workbook workbook) {
        workbook.setForceFormulaRecalculation(true);
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            Sheet sheet = workbook.getSheetAt(sheetNum);
            for (Row r : sheet) {
                for (Cell c : r) {
                    String cell;
                    if (c == null || c.getCellTypeEnum() != CellType.STRING || !StringUtil.isNotEmpty((String)(cell = c.getStringCellValue()))) continue;
                    if (cell.startsWith("=")) {
                        c.setCellFormula(cell.substring(1));
                        evaluator.evaluate(c);
                        continue;
                    }
                    if (!cell.startsWith(exportContext.getExportProperties().getFormulaPrefix())) continue;
                    c.setCellFormula(cell.substring(exportContext.getExportProperties().getFormulaPrefix().length()));
                    evaluator.evaluate(c);
                }
            }
        }
    }

    public void fill(WriteContext context, ExcelWriteFillExecutor excelWriteFillExecutor, Object data, FillConfig fillConfig, WriteSheet writeSheet, boolean ignoreFillKeyNotFound) {
        try {
            if (context.writeWorkbookHolder().getTempTemplateInputStream() == null) {
                throw new ExcelGenerateException("Calling the 'fill' method must use a template.");
            }
            context.currentSheet(writeSheet, WriteTypeEnum.FILL);
            excelWriteFillExecutor.fill(data, fillConfig);
        }
        catch (FillKeyNotFoundException e) {
            if (!ignoreFillKeyNotFound) {
                context.finish(true);
                throw e;
            }
        }
        catch (RuntimeException e) {
            context.finish(true);
            throw e;
        }
        catch (Exception e) {
            context.finish(true);
            throw new ExcelGenerateException((Throwable)e);
        }
    }

    public List<ExportFieldInfo> findExportFieldInfos(Class<?> clazz) {
        return ReflectUtil.getFields(clazz, (boolean)true).stream().map(this::findExportFieldInfo).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ExportFieldInfo findExportFieldInfo(Field field) {
        ExcelProperty exportField = field.getAnnotation(ExcelProperty.class);
        if (exportField != null) {
            String name = null;
            CharSequence[] value = exportField.value();
            if (value.length > 0) {
                name = String.join((CharSequence)".", value);
            }
            return ExportFieldInfo.builder().fieldName(field.getName()).name(name).order(exportField.index()).build();
        }
        return null;
    }
}

