/*
 * Decompiled with CFR 0.152.
 */
package elki.math.geodesy;

import elki.math.geodesy.AbstractEarthModel;
import elki.math.geodesy.SphereUtil;
import elki.utilities.optionhandling.Parameterizer;
import net.jafama.DoubleWrapper;
import net.jafama.FastMath;

public class SphericalCosineEarthModel
extends AbstractEarthModel {
    public static final SphericalCosineEarthModel STATIC = new SphericalCosineEarthModel();
    public static final double EARTH_RADIUS = 6371009.0;

    protected SphericalCosineEarthModel() {
        super(6371009.0, 6371009.0, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos((double)lat, (DoubleWrapper)tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos((double)lng, (DoubleWrapper)tmp);
        double clng = tmp.value;
        return new double[]{6371009.0 * clat * clng, 6371009.0 * clat * slng, 6371009.0 * slat};
    }

    @Override
    public double[] latLngRadToECEF(double lat, double lng, double h) {
        DoubleWrapper tmp = new DoubleWrapper();
        double slat = FastMath.sinAndCos((double)lat, (DoubleWrapper)tmp);
        double clat = tmp.value;
        double slng = FastMath.sinAndCos((double)lng, (DoubleWrapper)tmp);
        double clng = tmp.value;
        return new double[]{(6371009.0 + h) * clat * clng, (6371009.0 + h) * clat * slng, (6371009.0 + h) * slat};
    }

    @Override
    public double ecefToLatRad(double x, double y, double z) {
        double p = Math.sqrt(x * x + y * y);
        return FastMath.atan2((double)z, (double)p);
    }

    @Override
    public double distanceRad(double lat1, double lng1, double lat2, double lng2) {
        return 6371009.0 * SphereUtil.cosineFormulaRad((double)lat1, (double)lng1, (double)lat2, (double)lng2);
    }

    public static class Par
    implements Parameterizer {
        public SphericalCosineEarthModel make() {
            return STATIC;
        }
    }
}

