/*
 * Decompiled with CFR 0.152.
 */
package elki.index.projected;

import elki.data.NumberVector;
import elki.data.projection.LngLatToECEFProjection;
import elki.data.projection.Projection;
import elki.data.type.TypeInformation;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.distance.SpatialPrimitiveDistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.query.range.RangeSearcher;
import elki.database.query.rknn.RKNNSearcher;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.ProjectedView;
import elki.database.relation.Relation;
import elki.distance.geo.LatLngDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.index.Index;
import elki.index.IndexFactory;
import elki.index.KNNIndex;
import elki.index.RKNNIndex;
import elki.index.RangeIndex;
import elki.index.projected.ProjectedIndex;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.result.Metadata;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class LngLatAsECEFIndex<O extends NumberVector>
extends ProjectedIndex<O, O> {
    public LngLatAsECEFIndex(Relation<? extends O> relation, Projection<O, O> proj, Relation<O> view, Index inner, boolean norefine) {
        super(relation, proj, view, inner, norefine, 1.0);
        Metadata.of((Object)((Object)this)).setLongName("ECEF " + Metadata.of((Object)inner).getLongName());
    }

    public KNNSearcher<O> kNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof KNNIndex) || distanceQuery.getRelation() != this.relation || !LatLngDistance.class.isInstance(distanceQuery.getDistance()) || (flags & 4) == 0) {
            return null;
        }
        SpatialPrimitiveDistanceQuery innerQuery = EuclideanDistance.STATIC.instantiate(this.view);
        KNNSearcher innerq = ((KNNIndex)this.inner).kNNByObject((DistanceQuery)innerQuery, maxk, flags);
        return innerq != null ? new ProjectedIndex.ProjectedKNNByObject((ProjectedIndex)this, distanceQuery, innerq) : null;
    }

    public RangeSearcher<O> rangeByObject(DistanceQuery<O> distanceQuery, double maxradius, int flags) {
        if (!(this.inner instanceof RangeIndex) || distanceQuery.getRelation() != this.relation || !LatLngDistance.class.isInstance(distanceQuery.getDistance()) || (flags & 4) == 0) {
            return null;
        }
        SpatialPrimitiveDistanceQuery innerQuery = EuclideanDistance.STATIC.instantiate(this.view);
        RangeSearcher innerq = ((RangeIndex)this.inner).rangeByObject((DistanceQuery)innerQuery, maxradius, flags);
        return innerq != null ? new ProjectedIndex.ProjectedRangeByObject((ProjectedIndex)this, distanceQuery, innerq) : null;
    }

    public RKNNSearcher<O> rkNNByObject(DistanceQuery<O> distanceQuery, int maxk, int flags) {
        if (!(this.inner instanceof RKNNIndex) || distanceQuery.getRelation() != this.relation || !LatLngDistance.class.isInstance(distanceQuery.getDistance()) || (flags & 4) == 0) {
            return null;
        }
        SpatialPrimitiveDistanceQuery innerQuery = EuclideanDistance.STATIC.instantiate(this.view);
        RKNNSearcher innerq = ((RKNNIndex)this.inner).rkNNByObject((DistanceQuery)innerQuery, maxk, flags);
        return innerq != null ? new ProjectedIndex.ProjectedRKNNByObject((ProjectedIndex)this, distanceQuery, innerq) : null;
    }

    public static class Factory<O extends NumberVector>
    extends ProjectedIndex.Factory<O, O> {
        public Factory(IndexFactory<O> inner, boolean materialize, boolean norefine, EarthModel model) {
            super(new LngLatToECEFProjection(model), inner, materialize, norefine, 1.0);
        }

        public ProjectedIndex<O, O> instantiate(Relation<O> relation) {
            ProjectedView view;
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType((TypeInformation)relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            if (this.materialize) {
                DBIDs ids = relation.getDBIDs();
                WritableDataStore content = DataStoreUtil.makeStorage((DBIDs)ids, (int)30, (Class)this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter iter = ids.iter();
                while (iter.valid()) {
                    content.put((DBIDRef)iter, (Object)((NumberVector)this.proj.project((Object)((NumberVector)relation.get((DBIDRef)iter)))));
                    iter.advance();
                }
                view = new MaterializedRelation("ECEF Projection", this.proj.getOutputDataTypeInformation(), ids, (DataStore)content);
            } else {
                view = new ProjectedView(relation, this.proj);
            }
            Index inneri = this.inner.instantiate((Relation)view);
            if (inneri == null) {
                return null;
            }
            return new LngLatAsECEFIndex<O>(relation, this.proj, view, inneri, this.norefine);
        }

        public static class Par<O extends NumberVector>
        implements Parameterizer {
            IndexFactory<O> inner;
            boolean materialize = false;
            boolean norefine = false;
            EarthModel model;

            public void configure(Parameterization config) {
                new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                    this.model = x;
                });
                new ObjectParameter(ProjectedIndex.Factory.Par.INDEX_ID, IndexFactory.class).grab(config, x -> {
                    this.inner = x;
                });
                new Flag(ProjectedIndex.Factory.Par.MATERIALIZE_FLAG).grab(config, x -> {
                    this.materialize = x;
                });
                new Flag(ProjectedIndex.Factory.Par.DISABLE_REFINE_FLAG).grab(config, x -> {
                    this.norefine = x;
                });
            }

            public Factory<O> make() {
                return new Factory<O>(this.inner, this.materialize, this.norefine, this.model);
            }
        }
    }
}

