/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.geo;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.data.type.SimpleTypeInformation;
import elki.distance.NumberVectorDistance;
import elki.distance.SpatialPrimitiveDistance;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.NotImplementedException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class LngLatDistance
implements SpatialPrimitiveDistance<NumberVector>,
NumberVectorDistance<NumberVector> {
    private EarthModel model;

    public LngLatDistance(EarthModel model) {
        this.model = model;
    }

    public double distance(NumberVector o1, NumberVector o2) {
        return this.model.distanceDeg(o1.doubleValue(1), o1.doubleValue(0), o2.doubleValue(1), o2.doubleValue(0));
    }

    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector) {
            if (mbr2 instanceof NumberVector) {
                return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
            }
            NumberVector o1 = (NumberVector)mbr1;
            return this.model.minDistDeg(o1.doubleValue(1), o1.doubleValue(0), mbr2.getMin(1), mbr2.getMin(0), mbr2.getMax(1), mbr2.getMax(0));
        }
        if (mbr2 instanceof NumberVector) {
            NumberVector o2 = (NumberVector)mbr2;
            return this.model.minDistDeg(o2.doubleValue(1), o2.doubleValue(0), mbr1.getMin(1), mbr1.getMin(0), mbr1.getMax(1), mbr1.getMax(0));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return NumberVector.FIELD_2D;
    }

    public boolean isMetric() {
        return true;
    }

    public int hashCode() {
        return this.model.hashCode() + this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof LngLatDistance && this.model.equals(((LngLatDistance)obj).model);
    }

    public String toString() {
        return "LngLatDistance [model=" + this.model + "]";
    }

    public static class Par
    implements Parameterizer {
        EarthModel model;

        public void configure(Parameterization config) {
            new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                this.model = x;
            });
        }

        public LngLatDistance make() {
            return new LngLatDistance(this.model);
        }
    }
}

