/*
 * Decompiled with CFR 0.152.
 */
package elki.distance.geo;

import elki.data.NumberVector;
import elki.data.spatial.SpatialComparable;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.VectorFieldTypeInformation;
import elki.distance.NumberVectorDistance;
import elki.distance.SpatialPrimitiveDistance;
import elki.math.geodesy.EarthModel;
import elki.math.geodesy.SphericalVincentyEarthModel;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.NotImplementedException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.ParameterException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.WrongParameterValueException;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Geodetic Distance Queries on R-Trees for Indexing Geographic Data", booktitle="Int. Symp. Advances in Spatial and Temporal Databases (SSTD'2013)", url="https://doi.org/10.1007/978-3-642-40235-7_9", bibkey="DBLP:conf/ssd/SchubertZK13")
public class DimensionSelectingLatLngDistance
implements SpatialPrimitiveDistance<NumberVector>,
NumberVectorDistance<NumberVector> {
    final int dimlat;
    final int dimlng;
    final EarthModel model;

    public DimensionSelectingLatLngDistance(int dimlat, int dimlng, EarthModel model) {
        this.dimlat = dimlat;
        this.dimlng = dimlng;
        this.model = model;
    }

    public double distance(NumberVector o1, NumberVector o2) {
        return this.model.distanceDeg(o1.doubleValue(this.dimlat), o1.doubleValue(this.dimlng), o2.doubleValue(this.dimlat), o2.doubleValue(this.dimlng));
    }

    public double minDist(SpatialComparable mbr1, SpatialComparable mbr2) {
        if (mbr1 instanceof NumberVector) {
            if (mbr2 instanceof NumberVector) {
                return this.distance((NumberVector)mbr1, (NumberVector)mbr2);
            }
            NumberVector o1 = (NumberVector)mbr1;
            return this.model.minDistDeg(o1.doubleValue(this.dimlat), o1.doubleValue(this.dimlng), mbr2.getMin(this.dimlat), mbr2.getMin(this.dimlng), mbr2.getMax(this.dimlat), mbr2.getMax(this.dimlng));
        }
        if (mbr2 instanceof NumberVector) {
            NumberVector o2 = (NumberVector)mbr2;
            return this.model.minDistDeg(o2.doubleValue(this.dimlat), o2.doubleValue(this.dimlng), mbr1.getMin(this.dimlat), mbr1.getMin(this.dimlng), mbr1.getMax(this.dimlat), mbr1.getMax(this.dimlng));
        }
        throw new NotImplementedException("This distance function cannot - yet - be used with this algorithm, as the lower bound rectangle to rectangle distances have not yet been formalized for geodetic data.");
    }

    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, (int)Math.max(this.dimlat, this.dimlng), (int)Integer.MAX_VALUE);
    }

    public boolean isMetric() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimlat;
        result = 31 * result + this.dimlng;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof DimensionSelectingLatLngDistance && this.model.equals(((DimensionSelectingLatLngDistance)obj).model);
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID LATDIM_ID = new OptionID("distance.latitudedim", "The dimension containing the latitude.");
        public static final OptionID LNGDIM_ID = new OptionID("distance.longitudedim", "The dimension containing the longitude.");
        int dimlat;
        int dimlng;
        EarthModel model;

        public void configure(Parameterization config) {
            IntParameter dimlatP = (IntParameter)new IntParameter(LATDIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            dimlatP.grab(config, x -> {
                this.dimlat = x;
            });
            IntParameter dimlngP = (IntParameter)new IntParameter(LNGDIM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            dimlngP.grab(config, x -> {
                this.dimlng = x;
            });
            if (this.dimlat == this.dimlng) {
                config.reportError((ParameterException)new WrongParameterValueException((Parameter)dimlatP, "and", (Parameter)dimlngP, "should be different columns."));
            }
            new ObjectParameter(EarthModel.MODEL_ID, EarthModel.class, SphericalVincentyEarthModel.class).grab(config, x -> {
                this.model = x;
            });
        }

        public DimensionSelectingLatLngDistance make() {
            return new DimensionSelectingLatLngDistance(this.dimlat, this.dimlng, this.model);
        }
    }
}

