/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.search;

import io.github.dengliming.redismodule.redisearch.index.RSLanguage;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import io.github.dengliming.redismodule.redisearch.search.Filter;
import io.github.dengliming.redismodule.redisearch.search.HighlightOptions;
import io.github.dengliming.redismodule.redisearch.search.Page;
import io.github.dengliming.redismodule.redisearch.search.SortBy;
import io.github.dengliming.redismodule.redisearch.search.SummaryOptions;
import java.util.LinkedList;
import java.util.List;

public class SearchOptions {
    private boolean noContent;
    private boolean verbatim;
    private boolean noStopwords;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private String[] inKeys;
    private String[] inFields;
    private String[] returnFields;
    private String expander;
    private int slop;
    private boolean withInOrder;
    private List<Filter> filters = new LinkedList<Filter>();
    private RSLanguage language;
    private SummaryOptions summaryOptions;
    private HighlightOptions highlightOptions;
    private String scorer;
    private boolean explainScore;
    private String payload;
    private SortBy sortBy;
    private Page page;

    public boolean isNoContent() {
        return this.noContent;
    }

    public SearchOptions noContent() {
        this.noContent = true;
        return this;
    }

    public SearchOptions verbatim() {
        this.verbatim = true;
        return this;
    }

    public SearchOptions noStopwords() {
        this.noStopwords = true;
        return this;
    }

    public SearchOptions withScores() {
        this.withScores = true;
        return this;
    }

    public SearchOptions withPayloads() {
        this.withPayloads = true;
        return this;
    }

    public SearchOptions withSortKeys() {
        this.withSortKeys = true;
        return this;
    }

    public SearchOptions inKeys(String ... inKeys) {
        this.inKeys = inKeys;
        return this;
    }

    public SearchOptions inFields(String ... inFields) {
        this.inFields = inFields;
        return this;
    }

    public SearchOptions returnFields(String ... returnFields) {
        this.returnFields = returnFields;
        return this;
    }

    public SearchOptions expander(String expander) {
        this.expander = expander;
        return this;
    }

    public SearchOptions slop(int slop) {
        this.slop = slop;
        return this;
    }

    public SearchOptions withInOrder() {
        this.withInOrder = true;
        return this;
    }

    public SearchOptions filter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public SearchOptions language(RSLanguage language) {
        this.language = language;
        return this;
    }

    public SearchOptions summaryOptions(SummaryOptions summaryOptions) {
        this.summaryOptions = summaryOptions;
        return this;
    }

    public SearchOptions highlightOptions(HighlightOptions highlightOptions) {
        this.highlightOptions = highlightOptions;
        return this;
    }

    public SearchOptions page(Page page) {
        this.page = page;
        return this;
    }

    public SearchOptions page(int offset, int num) {
        this.page = new Page(offset, num);
        return this;
    }

    public SearchOptions scorer(String scorer) {
        this.scorer = scorer;
        return this;
    }

    public SearchOptions explainScore() {
        this.explainScore = true;
        return this;
    }

    public SearchOptions payload(String payload) {
        this.payload = payload;
        return this;
    }

    public SearchOptions sort(SortBy sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public void build(List<Object> args) {
        if (this.noContent) {
            args.add((Object)Keywords.NOCONTENT);
        }
        if (this.verbatim) {
            args.add((Object)Keywords.VERBATIM);
        }
        if (this.noStopwords) {
            args.add((Object)Keywords.NOSTOPWORDS);
        }
        if (this.withScores) {
            args.add((Object)Keywords.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add((Object)Keywords.WITHPAYLOADS);
        }
        if (this.withSortKeys) {
            args.add((Object)Keywords.WITHSORTKEYS);
        }
        if (this.filters != null) {
            this.filters.forEach(f -> f.build(args));
        }
        if (this.inKeys != null) {
            args.add((Object)Keywords.INKEYS);
            args.add(this.inKeys.length);
            for (String inKey : this.inKeys) {
                args.add(inKey);
            }
        }
        if (this.inFields != null) {
            args.add((Object)Keywords.INFIELDS);
            args.add(this.inFields.length);
            for (String inField : this.inFields) {
                args.add(inField);
            }
        }
        if (this.returnFields != null) {
            args.add((Object)Keywords.RETURN);
            args.add(this.returnFields.length);
            for (String returnField : this.returnFields) {
                args.add(returnField);
            }
        }
        if (this.summaryOptions != null) {
            this.summaryOptions.build(args);
        }
        if (this.highlightOptions != null) {
            this.highlightOptions.build(args);
        }
        if (this.slop > 0) {
            args.add((Object)Keywords.SLOP);
            args.add(this.slop);
        }
        if (this.withInOrder) {
            args.add((Object)Keywords.INORDER);
        }
        if (this.language != null) {
            args.add((Object)Keywords.LANGUAGE);
            args.add(this.language.name().toLowerCase());
        }
        if (this.expander != null) {
            args.add((Object)Keywords.EXPANDER);
            args.add(this.expander);
        }
        if (this.scorer != null) {
            args.add((Object)Keywords.SCORER);
            args.add(this.scorer);
        }
        if (this.explainScore) {
            args.add((Object)Keywords.EXPLAINSCORE);
        }
        if (this.payload != null) {
            args.add((Object)Keywords.PAYLOAD);
            args.add(this.payload);
        }
        if (this.sortBy != null) {
            this.sortBy.build(args);
        }
        if (this.page != null) {
            this.page.build(args);
        }
    }
}

