/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.search;

import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import io.github.dengliming.redismodule.redisearch.search.Filter;
import java.util.List;

public class NumericFilter
extends Filter {
    private final double min;
    private final boolean exclusiveMin;
    private final double max;
    private final boolean exclusiveMax;

    public NumericFilter(String field, double min, boolean exclusiveMin, double max) {
        this(field, min, exclusiveMin, max, false);
    }

    public NumericFilter(String field, double min, double max) {
        this(field, min, false, max, false);
    }

    public NumericFilter(String field, double min, double max, boolean exclusiveMax) {
        this(field, min, false, max, exclusiveMax);
    }

    public NumericFilter(String field, double min, boolean exclusiveMin, double max, boolean exclusiveMax) {
        super(field);
        this.min = min;
        this.exclusiveMin = exclusiveMin;
        this.max = max;
        this.exclusiveMax = exclusiveMax;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isExclusiveMin() {
        return this.exclusiveMin;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isExclusiveMax() {
        return this.exclusiveMax;
    }

    @Override
    public void build(List<Object> args) {
        args.add((Object)Keywords.FILTER);
        args.add(this.getField());
        args.add(this.formatNum(this.getMin(), this.exclusiveMin));
        args.add(this.formatNum(this.getMax(), this.exclusiveMax));
    }

    private String formatNum(double num, boolean exclude) {
        if (num == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (num == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        return exclude ? "(" + num : String.valueOf(num);
    }
}

