/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.search;

import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import io.github.dengliming.redismodule.redisearch.search.Filter;
import java.util.List;

public class GeoFilter
extends Filter {
    private final double lon;
    private final double lat;
    private final double radius;
    private final Unit unit;

    public GeoFilter(String field, double lon, double lat, double radius, Unit unit) {
        super(field);
        this.lon = lon;
        this.lat = lat;
        this.radius = radius;
        this.unit = unit;
    }

    public double getLon() {
        return this.lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getRadius() {
        return this.radius;
    }

    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public void build(List<Object> args) {
        args.add((Object)Keywords.GEOFILTER);
        args.add(this.getField());
        args.add(this.getLon());
        args.add(this.getLat());
        args.add(this.getRadius());
        args.add(this.getUnit().code);
    }

    public static enum Unit {
        KILOMETERS("km"),
        METERS("m"),
        FEET("ft"),
        MILES("mi");

        private String code;

        private Unit(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

