/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.protocol.decoder;

import io.github.dengliming.redismodule.redisearch.index.Document;
import io.github.dengliming.redismodule.redisearch.search.SearchResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class SearchResultDecoder
implements MultiDecoder<SearchResult> {
    private final boolean withScores;
    private final boolean noContent;

    public SearchResultDecoder(boolean withScores, boolean noContent) {
        this.withScores = withScores;
        this.noContent = noContent;
    }

    public SearchResult decode(List<Object> parts, State state) {
        Long total = (Long)parts.get(0);
        int documentSize = this.withScores ? 3 : 2;
        ArrayList<Document> documents = new ArrayList<Document>(total.intValue());
        if (documentSize == 2) {
            for (int i = 1; i < parts.size(); i += documentSize) {
                if (this.noContent) {
                    documents.add(new Document((String)parts.get(i), 1.0, null));
                    continue;
                }
                documents.add(new Document((String)parts.get(i), 1.0, (Map)parts.get(i + 1)));
            }
        } else {
            for (int i = 1; i < parts.size(); i += documentSize) {
                if (this.noContent) {
                    documents.add(new Document((String)parts.get(i), (Double)parts.get(i + 1), null));
                    continue;
                }
                documents.add(new Document((String)parts.get(i), Double.parseDouble((String)parts.get(i + 1)), (Map)parts.get(i + 2)));
            }
        }
        return new SearchResult(total, documents);
    }
}

