/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.index;

import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import java.util.List;

public class SuggestionOptions {
    private boolean fuzzy;
    private boolean withScores;
    private boolean withPayloads;
    private int maxNum;

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public SuggestionOptions fuzzy() {
        this.fuzzy = true;
        return this;
    }

    public SuggestionOptions withScores() {
        this.withScores = true;
        return this;
    }

    public SuggestionOptions withPayloads() {
        this.withPayloads = true;
        return this;
    }

    public SuggestionOptions maxNum(int num) {
        this.maxNum = num;
        return this;
    }

    public void build(List<Object> args) {
        if (this.isFuzzy()) {
            args.add(Keywords.FUZZY.name());
        }
        if (this.isWithScores()) {
            args.add(Keywords.WITHSCORES.name());
        }
        if (this.isWithPayloads()) {
            args.add(Keywords.WITHPAYLOADS.name());
        }
        if (this.getMaxNum() > 0) {
            args.add(Keywords.MAX.name());
            args.add(this.getMaxNum());
        }
    }
}

