/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.index;

import io.github.dengliming.redismodule.redisearch.index.IndexDefinition;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import java.util.List;

public class IndexOptions {
    private long expire;
    private boolean maxTextFields;
    private boolean noOffsets;
    private boolean noFreqs;
    private boolean noFields;
    private boolean noHL;
    private List<String> stopwords;
    private List<String> prefixes;
    private IndexDefinition definition;

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean isMaxTextFields() {
        return this.maxTextFields;
    }

    public IndexOptions maxTextFields() {
        this.maxTextFields = true;
        return this;
    }

    public boolean isNoOffsets() {
        return this.noOffsets;
    }

    public IndexOptions noOffsets() {
        this.noOffsets = true;
        return this;
    }

    public boolean isNoFreqs() {
        return this.noFreqs;
    }

    public IndexOptions noFreqs() {
        this.noFreqs = true;
        return this;
    }

    public boolean isNoFields() {
        return this.noFields;
    }

    public IndexOptions noFields() {
        this.noFields = true;
        return this;
    }

    public boolean isNoHL() {
        return this.noHL;
    }

    public IndexOptions noHL() {
        this.noHL = true;
        return this;
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public IndexOptions stopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public IndexOptions prefixes(List<String> prefixes) {
        this.prefixes = prefixes;
        return this;
    }

    public IndexOptions definition(IndexDefinition definition) {
        this.definition = definition;
        return this;
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    public static IndexOptions defaultOptions() {
        return new IndexOptions();
    }

    public void build(List<Object> args) {
        this.definition = this.getDefinition();
        if (this.definition != null) {
            args.add((Object)Keywords.ON);
            args.add((Object)this.definition.getDataType());
            if (this.definition.getPrefixes() != null) {
                args.add(Keywords.PREFIX.name());
                args.add(this.definition.getPrefixes().size());
                args.addAll(this.definition.getPrefixes());
            }
            if (this.definition.getFilter() != null) {
                args.add((Object)Keywords.FILTER);
                args.add(this.definition.getFilter());
            }
            if (this.definition.getLanguage() != null) {
                args.add((Object)Keywords.LANGUAGE);
                args.add((Object)this.definition.getLanguage());
            }
            if (this.definition.getLanguageField() != null) {
                args.add((Object)Keywords.LANGUAGE_FIELD);
                args.add((Object)this.definition.getLanguageField());
            }
            args.add((Object)Keywords.SCORE);
            args.add(this.definition.getScore());
            if (this.definition.getScoreFiled() != null) {
                args.add((Object)Keywords.SCORE_FIELD);
                args.add(this.definition.getScoreFiled());
            }
            if (this.definition.getPayloadField() != null) {
                args.add((Object)Keywords.PAYLOAD_FIELD);
                args.add(this.definition.getPayloadField());
            }
        }
        if (this.isMaxTextFields()) {
            args.add(Keywords.MAXTEXTFIELDS.name());
        }
        if (this.getExpire() > 0L) {
            args.add(Keywords.TEMPORARY.name());
            args.add(this.getExpire());
        }
        if (this.isNoOffsets()) {
            args.add(Keywords.NOOFFSETS.name());
        }
        if (this.isNoHL()) {
            args.add(Keywords.NOHL.name());
        }
        if (this.isNoFields()) {
            args.add(Keywords.NOFIELDS.name());
        }
        if (this.isNoFreqs()) {
            args.add(Keywords.NOFREQS.name());
        }
        if (this.getStopwords() != null) {
            args.add(Keywords.STOPWORDS.name());
            args.add(this.getStopwords().size());
            args.addAll(this.getStopwords());
        }
    }
}

