/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.index;

import io.github.dengliming.redismodule.redisearch.index.RSLanguage;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import java.util.List;

public class DocumentOptions {
    private RSLanguage language;
    private ReplacePolicy replacePolicy;
    private String replaceCondition;
    private boolean noSave;

    public RSLanguage getLanguage() {
        return this.language;
    }

    public ReplacePolicy getReplacePolicy() {
        return this.replacePolicy;
    }

    public String getReplaceCondition() {
        return this.replaceCondition;
    }

    public boolean isNoSave() {
        return this.noSave;
    }

    public DocumentOptions setNoSave(boolean noSave) {
        this.noSave = noSave;
        return this;
    }

    public DocumentOptions setLanguage(RSLanguage language) {
        this.language = language;
        return this;
    }

    public DocumentOptions setReplaceCondition(ReplacePolicy replacePolicy, String condition) {
        this.replacePolicy = replacePolicy;
        this.replaceCondition = condition;
        return this;
    }

    public void build(List<Object> args) {
        if (this.isNoSave()) {
            args.add(Keywords.NOSAVE.name());
        }
        if (this.getReplacePolicy() != null) {
            args.add(Keywords.REPLACE.name());
            if (this.getReplacePolicy() != ReplacePolicy.NONE) {
                args.add(this.getReplacePolicy().name());
            }
        }
        if (this.getLanguage() != null) {
            args.add(Keywords.LANGUAGE.name());
            args.add(this.getLanguage().name().toLowerCase());
        }
        if (this.getReplaceCondition() != null) {
            args.add(Keywords.IF.name());
            args.add(this.getReplaceCondition());
        }
    }

    public static enum ReplacePolicy {
        NONE,
        PARTIAL,
        NOCREATE;

    }
}

