/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.aggregate;

import io.github.dengliming.redismodule.redisearch.aggregate.SortField;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import java.util.List;

public class SortBy {
    private SortField[] sortFields;
    private int max;

    public SortBy(SortField ... sortFields) {
        this.sortFields = sortFields;
    }

    public SortBy max(int max) {
        this.max = max;
        return this;
    }

    public SortField[] getSortFields() {
        return this.sortFields;
    }

    public int getMax() {
        return this.max;
    }

    public void build(List<Object> args) {
        args.add((Object)Keywords.SORTBY);
        args.add(2 * this.sortFields.length);
        for (SortField sortField : this.sortFields) {
            args.add(sortField.getField());
            args.add(sortField.getOrder().name());
        }
        if (this.max > 0) {
            args.add((Object)Keywords.MAX);
            args.add(this.max);
        }
    }
}

