/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.aggregate;

import io.github.dengliming.redismodule.redisearch.aggregate.Reducer;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import java.util.List;
import org.redisson.api.SortOrder;

public final class Reducers {
    public static Reducer max(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.MAX, field);
    }

    public static Reducer avg(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.AVG, field);
    }

    public static Reducer count() {
        return new Reducer(null){

            @Override
            public void build(List<Object> args) {
                args.add((Object)Keywords.REDUCE);
                args.add((Object)Keywords.COUNT);
                args.add(0);
            }
        };
    }

    public static Reducer countDistinct(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.COUNT_DISTINCT, field);
    }

    public static Reducer countDistinctish(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.COUNT_DISTINCTISH, field);
    }

    public static Reducer sum(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.SUM, field);
    }

    public static Reducer min(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.MIN, field);
    }

    public static Reducer stdDev(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.STDDEV, field);
    }

    public static Reducer quantile(final String field, final double quantile) {
        return new Reducer(field){

            @Override
            public void build(List<Object> args) {
                args.add((Object)Keywords.REDUCE);
                args.add((Object)Keywords.QUANTILE);
                args.add(2);
                args.add(field);
                args.add(quantile);
            }
        };
    }

    public static Reducer toList(String field) {
        return Reducers.buildSingleFieldReducer(Keywords.TOLIST, field);
    }

    public static Reducer firstValue(String field) {
        return new FirstValue(field);
    }

    public static Reducer firstValue(String field, String by) {
        return new FirstValue(field).by(by);
    }

    public static Reducer firstValue(String field, String by, SortOrder order) {
        return new FirstValue(field).by(by, order);
    }

    public static Reducer randomSample(String field, int sampleSize) {
        return new RandomSample(field, sampleSize);
    }

    private static Reducer buildSingleFieldReducer(final Keywords name, final String field) {
        return new Reducer(field){

            @Override
            public void build(List<Object> args) {
                args.add((Object)Keywords.REDUCE);
                args.add((Object)name);
                args.add(1);
                args.add(field);
                if (this.getAlias() != null) {
                    args.add((Object)Keywords.AS);
                    args.add(this.getAlias());
                }
            }
        };
    }

    private static class RandomSample
    extends Reducer {
        private int sampleSize;

        RandomSample(String field, int sampleSize) {
            super(field);
            this.sampleSize = sampleSize;
        }

        @Override
        public void build(List<Object> args) {
            args.add((Object)Keywords.REDUCE);
            args.add((Object)Keywords.RANDOM_SAMPLE);
            args.add(2);
            args.add(this.getField());
            args.add(this.sampleSize);
        }
    }

    private static class FirstValue
    extends Reducer {
        private int nargs = 1;
        private String by;
        private SortOrder order;

        FirstValue(String field) {
            super(field);
        }

        public FirstValue by(String by, SortOrder order) {
            this.by = by;
            this.order = order;
            this.nargs += 3;
            return this;
        }

        public FirstValue by(String by) {
            this.by = by;
            this.nargs += 2;
            return this;
        }

        @Override
        public void build(List<Object> args) {
            args.add((Object)Keywords.REDUCE);
            args.add((Object)Keywords.FIRST_VALUE);
            args.add(this.nargs);
            args.add(this.getField());
            if (this.by != null) {
                args.add((Object)Keywords.BY);
                args.add(this.by);
                if (this.order != null) {
                    args.add(this.order.name());
                }
            }
        }
    }
}

