/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch.aggregate;

import io.github.dengliming.redismodule.redisearch.aggregate.Apply;
import io.github.dengliming.redismodule.redisearch.aggregate.Filter;
import io.github.dengliming.redismodule.redisearch.aggregate.Group;
import io.github.dengliming.redismodule.redisearch.aggregate.SortBy;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import io.github.dengliming.redismodule.redisearch.search.Page;
import java.util.List;

public class AggregateOptions {
    private boolean verbatim;
    private String[] loadFields;
    private Group[] groups;
    private SortBy sortBy;
    private Apply[] applies;
    private Page[] limits;
    private Filter[] filters;

    public AggregateOptions groups(Group ... groups) {
        this.groups = groups;
        return this;
    }

    public AggregateOptions verbatim() {
        this.verbatim = true;
        return this;
    }

    public AggregateOptions loads(String ... loadFields) {
        this.loadFields = loadFields;
        return this;
    }

    public AggregateOptions sortBy(SortBy sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public AggregateOptions applys(Apply ... applies) {
        this.applies = applies;
        return this;
    }

    public AggregateOptions filters(Filter ... filters) {
        this.filters = filters;
        return this;
    }

    public AggregateOptions limits(Page ... pages) {
        this.limits = pages;
        return this;
    }

    public void build(List<Object> args) {
        if (this.verbatim) {
            args.add((Object)Keywords.VERBATIM);
        }
        if (this.loadFields != null) {
            args.add((Object)Keywords.LOAD);
            args.add(this.loadFields.length);
            for (String loadField : this.loadFields) {
                args.add(loadField);
            }
        }
        if (this.groups != null) {
            for (Group group : this.groups) {
                group.build(args);
            }
        }
        if (this.sortBy != null) {
            this.sortBy.build(args);
        }
        if (this.applies != null) {
            for (Apply apply : this.applies) {
                apply.build(args);
            }
        }
        if (this.limits != null) {
            for (Page limit : this.limits) {
                limit.build(args);
            }
        }
        if (this.filters != null) {
            for (Filter filter : this.filters) {
                filter.build(args);
            }
        }
    }
}

