/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisearch;

import io.github.dengliming.redismodule.common.util.ArgsUtil;
import io.github.dengliming.redismodule.common.util.RAssert;
import io.github.dengliming.redismodule.redisearch.aggregate.AggregateOptions;
import io.github.dengliming.redismodule.redisearch.aggregate.AggregateResult;
import io.github.dengliming.redismodule.redisearch.index.ConfigOption;
import io.github.dengliming.redismodule.redisearch.index.Document;
import io.github.dengliming.redismodule.redisearch.index.DocumentOptions;
import io.github.dengliming.redismodule.redisearch.index.IndexOptions;
import io.github.dengliming.redismodule.redisearch.index.RSLanguage;
import io.github.dengliming.redismodule.redisearch.index.Suggestion;
import io.github.dengliming.redismodule.redisearch.index.SuggestionOptions;
import io.github.dengliming.redismodule.redisearch.index.schema.Field;
import io.github.dengliming.redismodule.redisearch.index.schema.Schema;
import io.github.dengliming.redismodule.redisearch.index.schema.TagField;
import io.github.dengliming.redismodule.redisearch.index.schema.TextField;
import io.github.dengliming.redismodule.redisearch.protocol.Keywords;
import io.github.dengliming.redismodule.redisearch.protocol.RedisCommands;
import io.github.dengliming.redismodule.redisearch.protocol.decoder.SearchResultDecoder;
import io.github.dengliming.redismodule.redisearch.protocol.decoder.StringMapInfoDecoder;
import io.github.dengliming.redismodule.redisearch.search.MisspelledTerm;
import io.github.dengliming.redismodule.redisearch.search.SearchOptions;
import io.github.dengliming.redismodule.redisearch.search.SearchResult;
import io.github.dengliming.redismodule.redisearch.search.SpellCheckOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.command.CommandAsyncExecutor;

public class RediSearch
extends RedissonObject {
    public RediSearch(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    public RediSearch(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, name);
    }

    public boolean createIndex(Schema schema) {
        return this.createIndex(schema, IndexOptions.defaultOptions());
    }

    public boolean createIndex(Schema schema, IndexOptions indexOptions) {
        return (Boolean)this.get(this.createIndexAsync(schema, indexOptions));
    }

    public RFuture<Boolean> createIndexAsync(Schema schema, IndexOptions indexOptions) {
        RAssert.notNull((Object)indexOptions, (String)"IndexOptions must be not null");
        RAssert.notNull((Object)schema, (String)"IndexSchema must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        indexOptions.build(args);
        args.add(Keywords.SCHEMA.name());
        schema.getFields().forEach(field -> this.appendFieldArgs((List<Object>)args, (Field)field));
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_CREATE, args.toArray());
    }

    public boolean alterIndex(Field ... fields) {
        return (Boolean)this.get(this.alterIndexAsync(fields));
    }

    public RFuture<Boolean> alterIndexAsync(Field ... fields) {
        RAssert.notEmpty((Object[])fields, (String)"Fields must be not empty");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(Keywords.SCHEMA.name());
        args.add(Keywords.ADD.name());
        for (Field field : fields) {
            this.appendFieldArgs(args, field);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ALTER, args.toArray());
    }

    private void appendFieldArgs(List<Object> args, Field field) {
        args.add(field.getName());
        if (field.getAttribute() != null) {
            args.add((Object)Keywords.AS);
            args.add(field.getAttribute());
        }
        args.add(field.getFieldType().name());
        switch (field.getFieldType()) {
            case TAG: {
                args.add(Keywords.SEPARATOR.name());
                args.add(((TagField)field).getSeparator());
                break;
            }
            case TEXT: {
                TextField textField = (TextField)field;
                args.add(Keywords.WEIGHT.name());
                args.add(textField.getWeight());
                if (textField.isNoStem()) {
                    args.add(Keywords.NOSTEM.name());
                }
                if (textField.getPhonetic() == null) break;
                args.add(Keywords.PHONETIC.name());
                args.add(textField.getPhonetic().name());
                break;
            }
        }
        if (field.isSortable()) {
            args.add(Keywords.SORTABLE.name());
        }
        if (field.isNoIndex()) {
            args.add(Keywords.NOINDEX.name());
        }
    }

    public boolean dropIndex() {
        return this.dropIndex(false);
    }

    public boolean dropIndex(boolean keepDocs) {
        return (Boolean)this.get(this.dropIndexAsync(keepDocs));
    }

    public RFuture<Boolean> dropIndexAsync(boolean keepDocs) {
        if (keepDocs) {
            return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DROP, new Object[]{this.getName(), Keywords.KEEPDOCS.name()});
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DROP, new Object[]{this.getName()});
    }

    public Map<String, Object> loadIndex() {
        return (Map)this.get(this.loadIndexAsync());
    }

    public RFuture<Map<String, Object>> loadIndexAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_INFO, new Object[]{this.getName()});
    }

    public boolean addDocument(Document document) {
        return this.addDocument(document, new DocumentOptions());
    }

    public boolean addDocument(Document document, DocumentOptions options) {
        return (Boolean)this.get(this.addDocumentAsync(document, options));
    }

    public RFuture<Boolean> addDocumentAsync(Document document, DocumentOptions options) {
        RAssert.notNull((Object)document, (String)"Document must be not null");
        RAssert.notNull((Object)options, (String)"DocumentOptions must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(document.getId());
        args.add(document.getScore());
        if (document.getPayload() != null) {
            args.add(Keywords.PAYLOAD.name());
            args.add(document.getPayload());
        }
        options.build(args);
        args.add(Keywords.FIELDS.name());
        document.getFields().forEach((k, v) -> {
            args.add(k);
            args.add(v);
        });
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ADD, args.toArray());
    }

    public Map<String, Object> getDocument(String docId) {
        return (Map)this.get(this.getDocumentAsync(docId));
    }

    public RFuture<Map<String, Object>> getDocumentAsync(String docId) {
        RAssert.notNull((Object)docId, (String)"docId must be not null");
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_GET, new Object[]{this.getName(), docId});
    }

    public List<Map<String, Object>> getDocuments(String ... docIds) {
        return (List)this.get(this.getDocumentsAsync(docIds));
    }

    public RFuture<List<Map<String, Object>>> getDocumentsAsync(String ... docIds) {
        RAssert.notEmpty((Object[])docIds, (String)"docIds must be not empty");
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_MGET, ArgsUtil.append((Object)this.getName(), (Object[])docIds));
    }

    public boolean deleteDocument(String docId) {
        return this.deleteDocument(docId, false);
    }

    public boolean deleteDocument(String docId, boolean deleteDocument) {
        return (Boolean)this.get(this.deleteDocumentAsync(docId, deleteDocument));
    }

    public RFuture<Boolean> deleteDocumentAsync(String docId, boolean deleteDocument) {
        RAssert.notNull((Object)docId, (String)"docId must be not null");
        if (deleteDocument) {
            return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DEL, new Object[]{this.getName(), docId, Keywords.DD.name()});
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DEL, new Object[]{this.getName(), docId});
    }

    public boolean addHash(String docId, double score) {
        return this.addHash(docId, score, null);
    }

    public boolean addHash(String docId, double score, RSLanguage language) {
        return this.addHash(docId, score, language, false);
    }

    public boolean addHash(String docId, double score, RSLanguage language, boolean replace) {
        return (Boolean)this.get(this.addHashAsync(docId, score, language, replace));
    }

    public RFuture<Boolean> addHashAsync(String docId, double score, RSLanguage language, boolean replace) {
        RAssert.notNull((Object)docId, (String)"docId must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(docId);
        args.add(score);
        if (language != null) {
            args.add(Keywords.LANGUAGE.name());
            args.add(language.name().toLowerCase());
        }
        if (replace) {
            args.add(Keywords.REPLACE.name());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ADDHASH, args.toArray());
    }

    public boolean addAlias(String alias) {
        return (Boolean)this.get(this.addAliasAsync(alias));
    }

    public RFuture<Boolean> addAliasAsync(String alias) {
        RAssert.notNull((Object)alias, (String)"alias must be not null");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ALIASADD, new Object[]{alias, this.getName()});
    }

    public boolean updateAlias(String alias) {
        return (Boolean)this.get(this.updateAliasAsync(alias));
    }

    public RFuture<Boolean> updateAliasAsync(String alias) {
        RAssert.notNull((Object)alias, (String)"alias must be not null");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ALIASUPDATE, new Object[]{alias, this.getName()});
    }

    public boolean deleteAlias(String alias) {
        return (Boolean)this.get(this.deleteAliasAsync(alias));
    }

    public RFuture<Boolean> deleteAliasAsync(String alias) {
        RAssert.notNull((Object)alias, (String)"alias must be not null");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_ALIASDEL, new Object[]{alias});
    }

    public String explain(String query) {
        return (String)this.get(this.explainAsync(query));
    }

    public RFuture<String> explainAsync(String query) {
        RAssert.notNull((Object)query, (String)"query must be not null");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_EXPLAIN, new Object[]{this.getName(), query});
    }

    public boolean setConfig(ConfigOption option, String value) {
        return (Boolean)this.get(this.setConfigAsync(option, value));
    }

    public RFuture<Boolean> setConfigAsync(ConfigOption option, String value) {
        RAssert.notNull((Object)((Object)option), (String)"ConfigOption must be not null");
        RAssert.notNull((Object)value, (String)"value must be not null");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_CONFIG_SET, new Object[]{option.getKeyword(), value});
    }

    public Map<String, String> getConfig(ConfigOption option) {
        return (Map)this.get(this.getConfigAsync(option));
    }

    public RFuture<Map<String, String>> getConfigAsync(ConfigOption option) {
        RAssert.notNull((Object)((Object)option), (String)"ConfigOption must be not null");
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_CONFIG_GET, new Object[]{option.getKeyword()});
    }

    public Map<String, String> getHelp(ConfigOption option) {
        return (Map)this.get(this.getHelpAsync(option));
    }

    public RFuture<Map<String, String>> getHelpAsync(ConfigOption option) {
        RAssert.notNull((Object)((Object)option), (String)"ConfigOption must be not null");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_CONFIG_HELP, new Object[]{option.getKeyword()});
    }

    public int addDict(String dictName, String ... terms) {
        return (Integer)this.get(this.addDictAsync(dictName, terms));
    }

    public RFuture<Integer> addDictAsync(String dictName, String ... terms) {
        RAssert.notNull((Object)dictName, (String)"dictName must be not null");
        RAssert.notEmpty((Object[])terms, (String)"terms must be not empty");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DICTADD, ArgsUtil.append((Object)dictName, (Object[])terms));
    }

    public int deleteDict(String dictName, String ... terms) {
        return (Integer)this.get(this.deleteDictAsync(dictName, terms));
    }

    public RFuture<Integer> deleteDictAsync(String dictName, String ... terms) {
        RAssert.notNull((Object)dictName, (String)"dictName must be not null");
        RAssert.notEmpty((Object[])terms, (String)"terms must be not empty");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_DICTDEL, ArgsUtil.append((Object)dictName, (Object[])terms));
    }

    public List<String> dumpDict(String dictName) {
        return (List)this.get(this.dumpDictAsync(dictName));
    }

    public RFuture<List<String>> dumpDictAsync(String dictName) {
        RAssert.notNull((Object)dictName, (String)"dictName must be not null");
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_DICTDUMP, new Object[]{dictName});
    }

    public long addSynonym(String ... terms) {
        return (Long)this.get(this.addSynonymAsync(terms));
    }

    public RFuture<Long> addSynonymAsync(String ... terms) {
        RAssert.notEmpty((Object[])terms, (String)"terms must be not empty");
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_SYNADD, ArgsUtil.append((Object)this.getName(), (Object[])terms));
    }

    public boolean updateSynonym(long synonymGroupId, String ... terms) {
        return (Boolean)this.get(this.updateSynonymAsync(synonymGroupId, terms));
    }

    public RFuture<Boolean> updateSynonymAsync(long synonymGroupId, String ... terms) {
        RAssert.notEmpty((Object[])terms, (String)"terms must be not empty");
        ArrayList<Object> args = new ArrayList<Object>(terms.length + 2);
        args.add(this.getName());
        args.add(synonymGroupId);
        Arrays.stream(terms).forEach(args::add);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_SYNUPDATE, args.toArray());
    }

    public Map<String, List<Long>> dumpSynonyms() {
        return (Map)this.get(this.dumpSynonymsAsync());
    }

    public RFuture<Map<String, List<Long>>> dumpSynonymsAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_SYNDUMP, new Object[]{this.getName()});
    }

    public List<String> getTagVals(String fieldName) {
        return (List)this.get(this.getTagValsAsync(fieldName));
    }

    public RFuture<List<String>> getTagValsAsync(String fieldName) {
        RAssert.notNull((Object)fieldName, (String)"fieldName must be not null");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_TAGVALS, new Object[]{this.getName(), fieldName});
    }

    public int addSuggestion(Suggestion suggestion) {
        return this.addSuggestion(suggestion, false);
    }

    public int addSuggestion(Suggestion suggestion, boolean increment) {
        return (Integer)this.get(this.addSuggestionAsync(suggestion, increment));
    }

    public RFuture<Integer> addSuggestionAsync(Suggestion suggestion, boolean increment) {
        RAssert.notNull((Object)suggestion, (String)"Suggestion must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(suggestion.getTerm());
        args.add(suggestion.getScore());
        if (increment) {
            args.add(Keywords.INCR.name());
        }
        if (suggestion.getPayload() != null) {
            args.add(Keywords.PAYLOAD.name());
            args.add(suggestion.getPayload());
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.FT_SUGADD, args.toArray());
    }

    public int getSuggestionLength() {
        return (Integer)this.get(this.getSuggestionLengthAsync());
    }

    public RFuture<Integer> getSuggestionLengthAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_SUGLEN, new Object[]{this.getName()});
    }

    public boolean deleteSuggestion(String term) {
        return (Boolean)this.get(this.deleteSuggestionAsync(term));
    }

    public RFuture<Boolean> deleteSuggestionAsync(String term) {
        RAssert.notNull((Object)term, (String)"term must be not null");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_SUGDEL, new Object[]{this.getName(), term});
    }

    public List<Suggestion> getSuggestion(String prefix, SuggestionOptions options) {
        return (List)this.get(this.getSuggestionAsync(prefix, options));
    }

    public RFuture<List<Suggestion>> getSuggestionAsync(String prefix, SuggestionOptions options) {
        RAssert.notNull((Object)prefix, (String)"prefix must be not null");
        RAssert.notNull((Object)options, (String)"SuggestionOptions must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(prefix);
        options.build(args);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.FT_SUGGET, args.toArray());
    }

    public SearchResult search(String query, SearchOptions searchOptions) {
        return (SearchResult)this.get(this.searchAsync(query, searchOptions));
    }

    public RFuture<SearchResult> searchAsync(String query, SearchOptions searchOptions) {
        this.checkQueryArgument(query);
        RAssert.notNull((Object)searchOptions, (String)"SearchOptions must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(query);
        searchOptions.build(args);
        RedisCommand command = new RedisCommand("FT.SEARCH", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new SearchResultDecoder(searchOptions.isWithScores(), searchOptions.isNoContent()), new StringMapInfoDecoder()}));
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, command, args.toArray());
    }

    public AggregateResult aggregate(String query, AggregateOptions aggregateOptions) {
        return (AggregateResult)this.get(this.aggregateAsync(query, aggregateOptions));
    }

    public RFuture<AggregateResult> aggregateAsync(String query, AggregateOptions aggregateOptions) {
        this.checkQueryArgument(query);
        RAssert.notNull((Object)aggregateOptions, (String)"AggregateOptions must be not null");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(query);
        aggregateOptions.build(args);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_AGGREGATE, args.toArray());
    }

    public List<MisspelledTerm> spellCheck(String query, SpellCheckOptions options) {
        return (List)this.get(this.spellCheckAsync(query, options));
    }

    public RFuture<List<MisspelledTerm>> spellCheckAsync(String query, SpellCheckOptions options) {
        this.checkQueryArgument(query);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        args.add(query);
        if (options != null) {
            options.build(args);
        }
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_SPELLCHECK, args.toArray());
    }

    public List<String> listIndexes() {
        return (List)this.get(this.listIndexesAsync());
    }

    public RFuture<List<String>> listIndexesAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.FT_LIST, new Object[0]);
    }

    private void checkQueryArgument(String query) {
        RAssert.notNull((Object)query, (String)"query must be not null");
    }
}

