package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class NamedClusterRoleBindingBuilder extends NamedClusterRoleBindingFluentImpl<NamedClusterRoleBindingBuilder> implements VisitableBuilder<NamedClusterRoleBinding,NamedClusterRoleBindingBuilder>{

    NamedClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NamedClusterRoleBindingBuilder(){
            this(true);
    }
    public NamedClusterRoleBindingBuilder(Boolean validationEnabled){
            this(new NamedClusterRoleBinding(), validationEnabled);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NamedClusterRoleBinding(), validationEnabled);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBindingFluent<?> fluent,NamedClusterRoleBinding instance){
            this(fluent, instance, true);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBindingFluent<?> fluent,NamedClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withRoleBinding(instance.getRoleBinding()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBinding instance){
            this(instance,true);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withRoleBinding(instance.getRoleBinding()); 
            this.validationEnabled = validationEnabled; 
    }
    public NamedClusterRoleBindingBuilder(Validator validator){
            this(new NamedClusterRoleBinding(), true);
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBindingFluent<?> fluent,NamedClusterRoleBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withRoleBinding(instance.getRoleBinding()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public NamedClusterRoleBindingBuilder(NamedClusterRoleBinding instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withRoleBinding(instance.getRoleBinding()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public NamedClusterRoleBinding build(){
            NamedClusterRoleBinding buildable = new NamedClusterRoleBinding(fluent.getName(),fluent.getRoleBinding());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedClusterRoleBindingBuilder that = (NamedClusterRoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
