package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterPolicyBindingListBuilder extends ClusterPolicyBindingListFluentImpl<ClusterPolicyBindingListBuilder> implements VisitableBuilder<ClusterPolicyBindingList,ClusterPolicyBindingListBuilder>{

    ClusterPolicyBindingListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterPolicyBindingListBuilder(){
            this(true);
    }
    public ClusterPolicyBindingListBuilder(Boolean validationEnabled){
            this(new ClusterPolicyBindingList(), validationEnabled);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterPolicyBindingList(), validationEnabled);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingListFluent<?> fluent,ClusterPolicyBindingList instance){
            this(fluent, instance, true);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingListFluent<?> fluent,ClusterPolicyBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingList instance){
            this(instance,true);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBindingListBuilder(Validator validator){
            this(new ClusterPolicyBindingList(), true);
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingListFluent<?> fluent,ClusterPolicyBindingList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterPolicyBindingListBuilder(ClusterPolicyBindingList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterPolicyBindingList build(){
            ClusterPolicyBindingList buildable = new ClusterPolicyBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyBindingListBuilder that = (ClusterPolicyBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
