package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KubernetesRoleListFluent<A extends KubernetesRoleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,KubernetesRole item);
    public A setToItems(int index,KubernetesRole item);
    public A addToItems(KubernetesRole... items);
    public A addAllToItems(Collection<KubernetesRole> items);
    public A removeFromItems(KubernetesRole... items);
    public A removeAllFromItems(Collection<KubernetesRole> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KubernetesRole> getItems();
    public List<KubernetesRole> buildItems();
    public KubernetesRole buildItem(int index);
    public KubernetesRole buildFirstItem();
    public KubernetesRole buildLastItem();
    public KubernetesRole buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesRoleBuilder> predicate);
    public A withItems(List<KubernetesRole> items);
    public A withItems(KubernetesRole... items);
    public Boolean hasItems();
    public KubernetesRoleListFluent.ItemsNested<A> addNewItem();
    public KubernetesRoleListFluent.ItemsNested<A> addNewItemLike(KubernetesRole item);
    public KubernetesRoleListFluent.ItemsNested<A> setNewItemLike(int index,KubernetesRole item);
    public KubernetesRoleListFluent.ItemsNested<A> editItem(int index);
    public KubernetesRoleListFluent.ItemsNested<A> editFirstItem();
    public KubernetesRoleListFluent.ItemsNested<A> editLastItem();
    public KubernetesRoleListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesRoleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public KubernetesRoleListFluent.MetadataNested<A> withNewMetadata();
    public KubernetesRoleListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public KubernetesRoleListFluent.MetadataNested<A> editMetadata();
    public KubernetesRoleListFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesRoleListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesRoleFluent<KubernetesRoleListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<KubernetesRoleListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
