package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KubernetesRoleBindingListFluent<A extends KubernetesRoleBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,KubernetesRoleBinding item);
    public A setToItems(int index,KubernetesRoleBinding item);
    public A addToItems(KubernetesRoleBinding... items);
    public A addAllToItems(Collection<KubernetesRoleBinding> items);
    public A removeFromItems(KubernetesRoleBinding... items);
    public A removeAllFromItems(Collection<KubernetesRoleBinding> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KubernetesRoleBinding> getItems();
    public List<KubernetesRoleBinding> buildItems();
    public KubernetesRoleBinding buildItem(int index);
    public KubernetesRoleBinding buildFirstItem();
    public KubernetesRoleBinding buildLastItem();
    public KubernetesRoleBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesRoleBindingBuilder> predicate);
    public A withItems(List<KubernetesRoleBinding> items);
    public A withItems(KubernetesRoleBinding... items);
    public Boolean hasItems();
    public KubernetesRoleBindingListFluent.ItemsNested<A> addNewItem();
    public KubernetesRoleBindingListFluent.ItemsNested<A> addNewItemLike(KubernetesRoleBinding item);
    public KubernetesRoleBindingListFluent.ItemsNested<A> setNewItemLike(int index,KubernetesRoleBinding item);
    public KubernetesRoleBindingListFluent.ItemsNested<A> editItem(int index);
    public KubernetesRoleBindingListFluent.ItemsNested<A> editFirstItem();
    public KubernetesRoleBindingListFluent.ItemsNested<A> editLastItem();
    public KubernetesRoleBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesRoleBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public KubernetesRoleBindingListFluent.MetadataNested<A> withNewMetadata();
    public KubernetesRoleBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public KubernetesRoleBindingListFluent.MetadataNested<A> editMetadata();
    public KubernetesRoleBindingListFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesRoleBindingListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesRoleBindingFluent<KubernetesRoleBindingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<KubernetesRoleBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
