package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ReplicationControllerBuilder extends ReplicationControllerFluentImpl<ReplicationControllerBuilder> implements VisitableBuilder<ReplicationController,ReplicationControllerBuilder>{

    ReplicationControllerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ReplicationControllerBuilder(){
            this(true);
    }
    public ReplicationControllerBuilder(Boolean validationEnabled){
            this(new ReplicationController(), validationEnabled);
    }
    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent){
            this(fluent, true);
    }
    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReplicationController(), validationEnabled);
    }
    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,ReplicationController instance){
            this(fluent, instance, true);
    }
    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,ReplicationController instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplicationControllerBuilder(ReplicationController instance){
            this(instance,true);
    }
    public ReplicationControllerBuilder(ReplicationController instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplicationControllerBuilder(Validator validator){
            this(new ReplicationController(), true);
    }
    public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,ReplicationController instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ReplicationControllerBuilder(ReplicationController instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ReplicationController build(){
            ReplicationController buildable = new ReplicationController(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplicationControllerBuilder that = (ReplicationControllerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
