package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CephFSPersistentVolumeSourceBuilder extends CephFSPersistentVolumeSourceFluentImpl<CephFSPersistentVolumeSourceBuilder> implements VisitableBuilder<CephFSPersistentVolumeSource,CephFSPersistentVolumeSourceBuilder>{

    CephFSPersistentVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CephFSPersistentVolumeSourceBuilder(){
            this(true);
    }
    public CephFSPersistentVolumeSourceBuilder(Boolean validationEnabled){
            this(new CephFSPersistentVolumeSource(), validationEnabled);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CephFSPersistentVolumeSource(), validationEnabled);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,CephFSPersistentVolumeSource instance){
            this(fluent, instance, true);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,CephFSPersistentVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMonitors(instance.getMonitors()); 
            fluent.withPath(instance.getPath()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withSecretFile(instance.getSecretFile()); 
            fluent.withSecretRef(instance.getSecretRef()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSource instance){
            this(instance,true);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMonitors(instance.getMonitors()); 
            this.withPath(instance.getPath()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withSecretFile(instance.getSecretFile()); 
            this.withSecretRef(instance.getSecretRef()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public CephFSPersistentVolumeSourceBuilder(Validator validator){
            this(new CephFSPersistentVolumeSource(), true);
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSourceFluent<?> fluent,CephFSPersistentVolumeSource instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMonitors(instance.getMonitors()); 
            fluent.withPath(instance.getPath()); 
            fluent.withReadOnly(instance.getReadOnly()); 
            fluent.withSecretFile(instance.getSecretFile()); 
            fluent.withSecretRef(instance.getSecretRef()); 
            fluent.withUser(instance.getUser()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CephFSPersistentVolumeSourceBuilder(CephFSPersistentVolumeSource instance,Validator validator){
            this.fluent = this; 
            this.withMonitors(instance.getMonitors()); 
            this.withPath(instance.getPath()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withSecretFile(instance.getSecretFile()); 
            this.withSecretRef(instance.getSecretRef()); 
            this.withUser(instance.getUser()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CephFSPersistentVolumeSource build(){
            CephFSPersistentVolumeSource buildable = new CephFSPersistentVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.isReadOnly(),fluent.getSecretFile(),fluent.getSecretRef(),fluent.getUser());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CephFSPersistentVolumeSourceBuilder that = (CephFSPersistentVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
