package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NamedRoleFluent<A extends NamedRoleFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildRole instead.
 * @return The buildable object.
 */
@Deprecated public Role getRole();
    public Role buildRole();
    public A withRole(Role role);
    public Boolean hasRole();
    public NamedRoleFluent.RoleNested<A> withNewRole();
    public NamedRoleFluent.RoleNested<A> withNewRoleLike(Role item);
    public NamedRoleFluent.RoleNested<A> editRole();
    public NamedRoleFluent.RoleNested<A> editOrNewRole();
    public NamedRoleFluent.RoleNested<A> editOrNewRoleLike(Role item);

    public interface RoleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<NamedRoleFluent.RoleNested<N>>{

        
    public N and();    public N endRole();
}


}
