package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NamedRoleBindingFluent<A extends NamedRoleBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildRoleBinding instead.
 * @return The buildable object.
 */
@Deprecated public RoleBinding getRoleBinding();
    public RoleBinding buildRoleBinding();
    public A withRoleBinding(RoleBinding roleBinding);
    public Boolean hasRoleBinding();
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding();
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item);
    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding();
    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding();
    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(RoleBinding item);

    public interface RoleBindingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<NamedRoleBindingFluent.RoleBindingNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
