package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class KubernetesRoleBindingListBuilder extends KubernetesRoleBindingListFluentImpl<KubernetesRoleBindingListBuilder> implements VisitableBuilder<KubernetesRoleBindingList,KubernetesRoleBindingListBuilder>{

    KubernetesRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesRoleBindingListBuilder(){
            this(true);
    }
    public KubernetesRoleBindingListBuilder(Boolean validationEnabled){
            this(new KubernetesRoleBindingList(), validationEnabled);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRoleBindingList(), validationEnabled);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingListFluent<?> fluent,KubernetesRoleBindingList instance){
            this(fluent, instance, true);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingListFluent<?> fluent,KubernetesRoleBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingList instance){
            this(instance,true);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleBindingListBuilder(Validator validator){
            this(new KubernetesRoleBindingList(), true);
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingListFluent<?> fluent,KubernetesRoleBindingList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public KubernetesRoleBindingListBuilder(KubernetesRoleBindingList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public KubernetesRoleBindingList build(){
            KubernetesRoleBindingList buildable = new KubernetesRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRoleBindingListBuilder that = (KubernetesRoleBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
