package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NodeConfigSourceFluent<A extends NodeConfigSourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    
/**
 * This method has been deprecated, please use method buildConfigMapRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getConfigMapRef();
    public ObjectReference buildConfigMapRef();
    public A withConfigMapRef(ObjectReference configMapRef);
    public Boolean hasConfigMapRef();
    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRef();
    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item);
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editConfigMapRef();
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRef();
    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();

    public interface ConfigMapRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<NodeConfigSourceFluent.ConfigMapRefNested<N>>{

        
    public N and();    public N endConfigMapRef();
}


}
