/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Function;
import io.fabric8.utils.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesHelper {
    public static Long getLong(Properties properties, String key) {
        return PropertiesHelper.getLong(properties, key, null);
    }

    public static Long getLong(Properties properties, String key, Long defaultValue) {
        Object value = properties.get(key);
        if (value instanceof String) {
            return Long.parseLong(value.toString());
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return defaultValue;
    }

    public static long getLongValue(Properties properties, String key, long defaultValue) {
        return PropertiesHelper.getLong(properties, key, defaultValue);
    }

    public static long getLongValue(Map<String, String> map, String key, long defaultValue) {
        Properties properties = new Properties();
        properties.putAll(map);
        return PropertiesHelper.getLong(properties, key, defaultValue);
    }

    public static Integer getInteger(Properties properties, String key) {
        return PropertiesHelper.getInteger(properties, key, null);
    }

    public static Integer getInteger(Properties properties, String key, Integer defaultValue) {
        Object value = properties.get(key);
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        if (value instanceof Long) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return defaultValue;
    }

    public static int getIntegerValue(Properties properties, String key, int defaultValue) {
        return PropertiesHelper.getInteger(properties, key, defaultValue);
    }

    public static int getIntegerValue(Map<String, String> map, String key, int defaultValue) {
        Properties properties = new Properties();
        properties.putAll(map);
        return PropertiesHelper.getInteger(properties, key, defaultValue);
    }

    public static Map<String, String> findPropertiesWithPrefix(Properties properties, String prefix) {
        return PropertiesHelper.findPropertiesWithPrefix(properties, prefix, Functions.noop());
    }

    public static Map<String, String> findPropertiesWithPrefix(Properties properties, String prefix, Function<String, String> keyTransformer) {
        HashMap<String, String> answer = new HashMap<String, String>();
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String keyText;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (!(key instanceof String) || value == null || !(keyText = key.toString()).startsWith(prefix)) continue;
            String newKey = keyText.substring(prefix.length());
            if (keyTransformer != null) {
                newKey = keyTransformer.apply(newKey);
            }
            answer.put(newKey, value.toString());
        }
        return answer;
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> answer = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                Object value = entry.getValue();
                Object key = entry.getKey();
                if (key == null || value == null) continue;
                answer.put(key.toString(), value.toString());
            }
        }
        return answer;
    }
}

