/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.KubernetesServiceNotFoundException;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;

public class KubernetesServices {
    public static final String DEFAULT_PROTO = "tcp";
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    public static String serviceToHostAndPort(String serviceName, String portName, String defaultValue) {
        String host = KubernetesServices.serviceToHostOrBlank(serviceName);
        String port = KubernetesServices.serviceToPortOrBlank(serviceName, portName);
        if (Strings.isNullOrBlank(host) || Strings.isNullOrBlank(port)) {
            return defaultValue;
        }
        return host + ":" + port;
    }

    public static String serviceToHostAndPort(String serviceName, String portName) {
        String host = KubernetesServices.serviceToHost(serviceName);
        String port = KubernetesServices.serviceToPort(serviceName, portName);
        return host + ":" + port;
    }

    public static String serviceToHostOrBlank(String serviceName) {
        return Systems.getEnvVarOrSystemProperty(KubernetesServices.toServiceHostEnvironmentVariable(serviceName), "");
    }

    public static String serviceToHost(String serviceName) {
        String hostEnvVar = KubernetesServices.toServiceHostEnvironmentVariable(serviceName);
        String answer = Systems.getEnvVarOrSystemProperty(hostEnvVar, "");
        if (Strings.isNullOrBlank(answer)) {
            throw new KubernetesServiceNotFoundException(serviceName, hostEnvVar);
        }
        return answer;
    }

    public static String serviceToPort(String serviceName, String portName) {
        String portEnvVar = KubernetesServices.toServicePortEnvironmentVariable(serviceName, portName);
        String answer = Systems.getEnvVarOrSystemProperty(portEnvVar, "");
        if (Strings.isNullOrBlank(answer)) {
            throw new KubernetesServiceNotFoundException(serviceName, portEnvVar);
        }
        return answer;
    }

    public static String serviceToPortOrBlank(String serviceName) {
        return KubernetesServices.serviceToPortOrBlank(serviceName, null);
    }

    public static String serviceToPortOrBlank(String serviceName, String portName) {
        String envVarName = KubernetesServices.toServicePortEnvironmentVariable(serviceName, portName);
        return Systems.getEnvVarOrSystemProperty(envVarName, "");
    }

    public static String serviceToProtocol(String serviceName, String servicePort) {
        return Systems.getEnvVarOrSystemProperty(KubernetesServices.toEnvVariable(serviceName + PORT_SUFFIX + "_" + servicePort + PROTO_SUFFIX), DEFAULT_PROTO);
    }

    public static String toServiceHostEnvironmentVariable(String serviceName) {
        return KubernetesServices.toEnvVariable(serviceName + HOST_SUFFIX);
    }

    public static String toServicePortEnvironmentVariable(String serviceName, String portName) {
        String name = serviceName + PORT_SUFFIX + (Strings.isNotBlank(portName) ? "_" + portName : "");
        return KubernetesServices.toEnvVariable(name);
    }

    public static String toEnvVariable(String serviceName) {
        return serviceName.toUpperCase().replaceAll("-", "_");
    }
}

