/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.fabric8.maven.docker.model.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImageDetails
implements Image {
    public static final String CREATED = "Created";
    public static final String ID = "Id";
    public static final String LABELS = "Labels";
    public static final String PARENT_ID = "ParentId";
    public static final String REPO_TAGS = "RepoTags";
    public static final String REPO_DIGESTS = "RepoDigests";
    public static final String SIZE = "Size";
    public static final String VIRTUAL_SIZE = "VirtualSize";
    private final JsonObject json;

    public ImageDetails(JsonObject json) {
        this.json = json;
    }

    @Override
    public String getId() {
        return this.json.get(ID).getAsString();
    }

    @Override
    public String getParentId() {
        return this.json.has(PARENT_ID) ? this.json.get(PARENT_ID).getAsString() : null;
    }

    @Override
    public long getCreated() {
        return this.json.get(CREATED).getAsLong();
    }

    @Override
    public long getSize() {
        return this.json.get(SIZE).getAsLong();
    }

    @Override
    public long getVirtualSize() {
        return this.json.get(VIRTUAL_SIZE).getAsLong();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.json.has(LABELS) ? this.mapLabels(this.json.getAsJsonObject(LABELS)) : Collections.emptyMap();
    }

    @Override
    public List<String> getRepoTags() {
        ArrayList<String> repoTags = new ArrayList<String>();
        if (this.json.has(REPO_TAGS) && this.json.get(REPO_TAGS) instanceof JsonArray) {
            for (JsonElement item : this.json.getAsJsonArray(REPO_TAGS)) {
                repoTags.add(item.getAsString());
            }
        }
        return repoTags;
    }

    @Override
    public List<String> getRepoDigests() {
        ArrayList<String> repoDigests = new ArrayList<String>();
        if (this.json.has(REPO_DIGESTS)) {
            for (JsonElement item : this.json.getAsJsonArray(REPO_DIGESTS)) {
                repoDigests.add(item.getAsString());
            }
        }
        return repoDigests;
    }

    private Map<String, String> mapLabels(JsonObject labels) {
        int length = labels.size();
        LinkedHashMap<String, String> mapped = new LinkedHashMap<String, String>(length);
        for (String key : labels.keySet()) {
            mapped.put(key, labels.get(key).getAsString());
        }
        return mapped;
    }
}

