/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.cache;

import io.asyncer.r2dbc.mysql.util.AssertUtils;
import reactor.util.annotation.Nullable;

final class Lru<T> {
    static final int WINDOW = 1;
    static final int PROBATION = 2;
    static final int PROTECTION = 3;
    private final int limit;
    private final int eigenvalue;
    @Nullable
    private Node<T> head;
    @Nullable
    private Node<T> tail;
    private int size;

    Lru(int limit, int eigenvalue) {
        AssertUtils.require(limit > 0, "limit must be greater than 0");
        AssertUtils.require(eigenvalue > 0, "eigenvalue must be greater than 0");
        this.limit = limit;
        this.eigenvalue = eigenvalue;
    }

    void refresh(Node<T> node) {
        Node<T> head = this.head;
        if (node == head) {
            return;
        }
        Node prev = ((Node)node).prev;
        Node next = ((Node)node).next;
        if (head == null) {
            throw new IllegalStateException("LRU must not be empty");
        }
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        if (node == this.tail) {
            this.tail = prev;
        }
        ((Node)node).prev = null;
        ((Node)node).next = (Node)head;
        ((Node)head).prev = (Node)node;
        this.head = node;
    }

    @Nullable
    Node<T> push(Node<T> node) {
        Node tail;
        Node<T> head = this.head;
        ((Node)node).lru = this.eigenvalue;
        ((Node)node).prev = null;
        ((Node)node).next = (Node)head;
        if (head == null) {
            this.tail = node;
        } else {
            ((Node)head).prev = (Node)node;
        }
        this.head = node;
        if (this.size < this.limit) {
            ++this.size;
            return null;
        }
        Node<T> unlink = this.tail;
        if (unlink == null || (tail = ((Node)unlink).prev) == null) {
            throw new IllegalStateException("LRU must be contains least 2 elements when unlinking");
        }
        tail.next = null;
        this.tail = tail;
        ((Node)unlink).reInit();
        return unlink;
    }

    @Nullable
    Node<T> nextEviction() {
        return this.size < this.limit ? null : this.tail;
    }

    void remove(Node<T> node) {
        Node prev = ((Node)node).prev;
        Node next = ((Node)node).next;
        Node<T> head = this.head;
        Node<T> tail = this.tail;
        if (head == null || tail == null) {
            throw new IllegalStateException("LRU must not be empty");
        }
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        if (node == tail) {
            this.tail = prev;
        }
        if (node == head) {
            this.head = next;
        }
        --this.size;
        ((Node)node).reInit();
    }

    public String toString() {
        Node head = this.head;
        Node<T> tail = this.tail;
        if (head == null || tail == null) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        Node ptr = head;
        while (ptr != null && ptr != tail) {
            builder.append(ptr.value).append(',').append(' ');
            ptr = ptr.next;
        }
        return builder.append(((Node)tail).value).append(']').toString();
    }

    static final class Node<T> {
        private final String key;
        private final T value;
        private int lru;
        @Nullable
        private Node<T> prev;
        @Nullable
        private Node<T> next;

        Node(String key, T value) {
            this.key = key;
            this.value = value;
        }

        int getLru() {
            return this.lru;
        }

        String getKey() {
            return this.key;
        }

        T getValue() {
            return this.value;
        }

        private void reInit() {
            this.lru = 0;
            this.next = null;
            this.prev = null;
        }
    }
}

