/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.authentication;

import io.asyncer.r2dbc.mysql.authentication.AuthUtils;
import io.asyncer.r2dbc.mysql.authentication.MySqlAuthProvider;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.asyncer.r2dbc.mysql.util.InternalArrays;
import reactor.util.annotation.Nullable;

final class MySqlNativeAuthProvider
implements MySqlAuthProvider {
    static final MySqlNativeAuthProvider INSTANCE = new MySqlNativeAuthProvider();
    private static final String ALGORITHM = "SHA-1";
    private static final boolean IS_LEFT_SALT = true;

    @Override
    public boolean isSslNecessary() {
        return false;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, byte[] salt, CharCollation collation) {
        if (password == null || password.length() <= 0) {
            return InternalArrays.EMPTY_BYTES;
        }
        AssertUtils.requireNonNull(salt, "salt must not be null when password exists");
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        return AuthUtils.hash(ALGORITHM, true, password, salt, collation.getCharset());
    }

    @Override
    public MySqlAuthProvider next() {
        return this;
    }

    @Override
    public String getType() {
        return "mysql_native_password";
    }

    private MySqlNativeAuthProvider() {
    }
}

