/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.shared.extension;

import eu.maveniverse.maven.shared.core.maven.MavenUtils;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class RuntimeRequirementEnforcerLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String OFF = "OFF";

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Optional properties = MavenUtils.discoverProperties((ClassLoader)RuntimeRequirementEnforcerLifecycleParticipant.class.getClassLoader(), (String)"runtime-requirements.properties");
        if (properties.isPresent()) {
            Map p = (Map)properties.orElseThrow(() -> new IllegalStateException("No value"));
            this.logger.debug("Found runtime-requirements.properties on classpath");
            String applicationName = p.getOrDefault("applicationName", "Maven extension");
            String mavenRequirement = (String)p.get("mavenRequirement");
            String javaRequirement = (String)p.get("javaRequirement");
            if (mavenRequirement != null && javaRequirement != null) {
                if (!this.checkRuntimeRequirements(applicationName, mavenRequirement, javaRequirement)) {
                    throw new MavenExecutionException("Runtime requirements are not fulfilled", (Throwable)null);
                }
                this.logger.debug("Runtime requirements are fulfilled: {}", (Object)p);
            } else {
                this.logger.warn("Incomplete runtime-requirements.properties: {}", (Object)p);
            }
        } else {
            this.logger.debug("Not found runtime-requirements.properties on classpath");
        }
    }

    private boolean checkRuntimeRequirements(String name, String mavenRequirement, String javaRequirement) {
        String mavenVersionString = MavenUtils.discoverArtifactVersion((ClassLoader)Version.class.getClassLoader(), (String)"org.apache.maven", (String)"maven-core", null);
        String javaVersionString = System.getProperty("java.version");
        if (mavenVersionString == null || javaVersionString == null) {
            throw new IllegalStateException("Maven and/or Java version could not be determined");
        }
        try {
            boolean runtimeRequirements;
            if (javaVersionString.startsWith("1.") && javaVersionString.length() > 2) {
                javaVersionString = javaVersionString.substring(2);
            }
            GenericVersionScheme versionScheme = new GenericVersionScheme();
            VersionConstraint mavenConstraint = null;
            if (!OFF.equals(mavenRequirement)) {
                mavenConstraint = versionScheme.parseVersionConstraint(mavenRequirement);
            }
            VersionConstraint javaConstraint = null;
            if (!OFF.equals(javaRequirement)) {
                javaConstraint = versionScheme.parseVersionConstraint(javaRequirement);
            }
            Version mavenVersion = versionScheme.parseVersion(mavenVersionString);
            Version javaVersion = versionScheme.parseVersion(javaVersionString);
            boolean mavenOk = mavenConstraint == null || mavenConstraint.containsVersion(mavenVersion);
            boolean javaOk = javaConstraint == null || javaConstraint.containsVersion(javaVersion);
            boolean bl = runtimeRequirements = mavenOk && javaOk;
            if (!runtimeRequirements) {
                this.logger.warn("{} runtime requirements are not fulfilled:", (Object)name);
                if (!mavenOk) {
                    this.logger.warn(String.format("* Unsupported Maven version %s; supported versions are %s", mavenVersion, mavenConstraint));
                }
                if (!javaOk) {
                    this.logger.warn(String.format("* Unsupported Java version %s; supported versions are %s", javaVersion, javaConstraint));
                }
                this.logger.error("{} cannot operate in this environment: adapt your environment for requirements", (Object)name);
            }
            return runtimeRequirements;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("Maven and/or Java version could not be parsed", e);
        }
    }
}

