/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.extension3.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
final class NissePropertyInliner {
    private static final String INLINED_POM_PATH_KEY = NissePropertyInliner.class.getName() + ".inlined";
    private static final String NEEDS_INLINING_COLLECTION = "nisse.needs-inlining";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    NissePropertyInliner() {
    }

    public synchronized Collection<String> inlinedKeys(MavenSession session) {
        ConcurrentHashMap.KeySetView inlinedKeys = (ConcurrentHashMap.KeySetView)session.getRepositorySession().getData().get((Object)NEEDS_INLINING_COLLECTION);
        if (inlinedKeys == null) {
            inlinedKeys = ConcurrentHashMap.newKeySet();
            session.getRepositorySession().getData().set((Object)NEEDS_INLINING_COLLECTION, inlinedKeys);
        }
        return inlinedKeys;
    }

    void mayInlinePom(MavenSession session, Collection<MavenProject> mavenProjects) throws IOException {
        Collection<String> inlinedKeys = this.inlinedKeys(session);
        if (!inlinedKeys.isEmpty()) {
            HashMap<String, String> inlinedProperties = new HashMap<String, String>();
            for (String string : inlinedKeys) {
                inlinedProperties.put("${" + string + "}", session.getUserProperties().getProperty(string));
            }
            this.logger.info("Nisse inlining following properties:");
            for (Map.Entry entry : inlinedProperties.entrySet()) {
                this.logger.info(" * {}={}", entry.getKey(), entry.getValue());
            }
            this.logger.info("Checking POMs for inlining:");
            for (MavenProject mavenProject : mavenProjects) {
                Path pomPath = mavenProject.getFile().toPath();
                if (!this.isAnyKeyPresent(inlinedProperties, pomPath)) continue;
                this.logger.info(" * {}:{} needs inlining", (Object)mavenProject.getGroupId(), (Object)mavenProject.getArtifactId());
                Path inlinedPomPath = pomPath.getParent().resolve(".inlined-" + pomPath.getFileName());
                session.getRepositorySession().getData().set((Object)INLINED_POM_PATH_KEY, (Object)inlinedPomPath);
                this.inline(pomPath, inlinedPomPath, inlinedProperties);
                mavenProject.setPomFile(inlinedPomPath.toFile());
            }
        } else {
            this.logger.info("No need for inlining");
        }
    }

    void cleanup(MavenSession session, Collection<MavenProject> mavenProjects) throws IOException {
        Path inlinedPom = (Path)session.getRepositorySession().getData().get((Object)INLINED_POM_PATH_KEY);
        if (inlinedPom != null) {
            Files.deleteIfExists(inlinedPom);
        }
    }

    private boolean isAnyKeyPresent(Map<String, String> inlinedProperties, Path file) throws IOException {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            boolean bl = lines.anyMatch(l -> {
                for (String placeholder : inlinedProperties.keySet()) {
                    if (!l.contains(placeholder)) continue;
                    return true;
                }
                return false;
            });
            return bl;
        }
    }

    private void inline(Path sourcePom, Path targetPom, Map<String, String> inlinedProperties) throws IOException {
        Function<String, String> replacer = line -> {
            if (line.contains("${") && line.contains("}")) {
                String processed = line;
                for (Map.Entry entry : inlinedProperties.entrySet()) {
                    processed = processed.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                return processed;
            }
            return line;
        };
        try (Stream<String> lines = Files.lines(sourcePom, StandardCharsets.UTF_8).map(replacer);){
            Files.write(targetPom, (Iterable<? extends CharSequence>)lines.collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }
}

