/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import jcifs.Configuration;
import jcifs.netbios.Name;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.util.Strings;

class NodeStatusResponse
extends NameServicePacket {
    private NbtAddress queryAddress;
    private int numberOfNames;
    private byte[] macAddress;
    private byte[] stats;
    NbtAddress[] addressArray;

    NodeStatusResponse(Configuration cfg, NbtAddress queryAddress) {
        super(cfg);
        this.queryAddress = queryAddress;
        this.recordName = new Name(cfg);
        this.macAddress = new byte[6];
    }

    @Override
    int writeBodyWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readBodyWireFormat(byte[] src, int srcIndex) {
        return this.readResourceRecordWireFormat(src, srcIndex);
    }

    @Override
    int writeRDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readRDataWireFormat(byte[] src, int srcIndex) {
        int start = srcIndex;
        this.numberOfNames = src[srcIndex] & 0xFF;
        int namesLength = this.numberOfNames * 18;
        int statsLength = this.rDataLength - namesLength - 1;
        this.numberOfNames = src[srcIndex++] & 0xFF;
        System.arraycopy(src, srcIndex + namesLength, this.macAddress, 0, 6);
        srcIndex += this.readNodeNameArray(src, srcIndex);
        this.stats = new byte[statsLength];
        System.arraycopy(src, srcIndex, this.stats, 0, statsLength);
        return (srcIndex += statsLength) - start;
    }

    private int readNodeNameArray(byte[] src, int srcIndex) {
        int start = srcIndex;
        this.addressArray = new NbtAddress[this.numberOfNames];
        String scope = this.queryAddress.hostName.scope;
        boolean addrFound = false;
        for (int i = 0; i < this.numberOfNames; ++i) {
            boolean isPermanent;
            int j = srcIndex + 14;
            while (src[j] == 32) {
                --j;
            }
            String n = Strings.fromOEMBytes(src, srcIndex, j - srcIndex + 1, this.config);
            int hexCode = src[srcIndex + 15] & 0xFF;
            boolean groupName = (src[srcIndex + 16] & 0x80) == 128;
            int ownerNodeType = (src[srcIndex + 16] & 0x60) >> 5;
            boolean isBeingDeleted = (src[srcIndex + 16] & 0x10) == 16;
            boolean isInConflict = (src[srcIndex + 16] & 8) == 8;
            boolean isActive = (src[srcIndex + 16] & 4) == 4;
            boolean bl = isPermanent = (src[srcIndex + 16] & 2) == 2;
            if (!addrFound && this.queryAddress.hostName.hexCode == hexCode && (this.queryAddress.hostName.isUnknown() || this.queryAddress.hostName.name.equals(n))) {
                if (this.queryAddress.hostName.isUnknown()) {
                    this.queryAddress.hostName = new Name(this.config, n, hexCode, scope);
                }
                this.queryAddress.groupName = groupName;
                this.queryAddress.nodeType = ownerNodeType;
                this.queryAddress.isBeingDeleted = isBeingDeleted;
                this.queryAddress.isInConflict = isInConflict;
                this.queryAddress.isActive = isActive;
                this.queryAddress.isPermanent = isPermanent;
                this.queryAddress.macAddress = this.macAddress;
                this.queryAddress.isDataFromNodeStatus = true;
                addrFound = true;
                this.addressArray[i] = this.queryAddress;
            } else {
                this.addressArray[i] = new NbtAddress(new Name(this.config, n, hexCode, scope), this.queryAddress.address, groupName, ownerNodeType, isBeingDeleted, isInConflict, isActive, isPermanent, this.macAddress);
            }
            srcIndex += 18;
        }
        return srcIndex - start;
    }

    @Override
    public String toString() {
        return new String("NodeStatusResponse[" + super.toString() + "]");
    }
}

