/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.BundleContextAtomos;
import dev.equo.solstice.BundleContextShim;
import dev.equo.solstice.Capability;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.SolsticeFrameworkUtilHelper;
import dev.equo.solstice.SolsticeManifest;
import dev.equo.solstice.Unchecked;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Solstice {
    private final Logger logger = LoggerFactory.getLogger(Solstice.class);
    private final List<SolsticeManifest> bundles;
    private final TreeSet<String> pkgs = new TreeSet();
    private final Capability.SupersetSet caps = new Capability.SupersetSet();
    private BundleContext context;
    private final Set<SolsticeManifest> activatingBundles = new HashSet<SolsticeManifest>();

    private static Map<String, List<String>> knownMissingBundleDependencies() {
        return Map.of("org.eclipse.equinox.p2.reconciler.dropins", List.of("org.eclipse.equinox.p2.updatesite"));
    }

    public static Solstice findBundlesOnClasspath() {
        Enumeration manifestURLs = Unchecked.get(() -> SolsticeManifest.class.getClassLoader().getResources("META-INF/MANIFEST.MF"));
        int classpathOrder = 0;
        ArrayList<SolsticeManifest> manifests = new ArrayList<SolsticeManifest>();
        while (manifestURLs.hasMoreElements()) {
            SolsticeManifest manifest = new SolsticeManifest((URL)manifestURLs.nextElement(), ++classpathOrder);
            if (manifest.getSymbolicName() == null) continue;
            manifests.add(manifest);
        }
        return new Solstice(manifests);
    }

    private Solstice(List<SolsticeManifest> bundles) {
        this.bundles = bundles;
        for (SolsticeManifest fragment : bundles) {
            String host = fragment.fragmentHost();
            if (host == null) continue;
            SolsticeManifest hostBundle = this.bundleForSymbolicName(host);
            if (hostBundle == null) {
                throw new IllegalArgumentException("Fragment " + fragment + " needs missing " + host);
            }
            hostBundle.fragments.add(fragment);
        }
        this.ensureOrder("org.eclipse.jdt.core", "org.apache.jasper.glassfish", "Eclipse has multiple jars which define `ICompilationUnit`.");
        this.ensureOrder("org.eclipse.jdt.core.compiler.batch", "org.apache.jasper.glassfish", "Eclipse has multiple jars which define `ICompilationUnit`.");
        this.ensureOrder("org.eclipse.osgi", "biz.aQute.bndlib", "bndlib contains org.osgi.service.log");
    }

    private void ensureOrder(String beforeName, String afterName, String reason) {
        SolsticeManifest before = this.bundleForSymbolicName(beforeName);
        SolsticeManifest after = this.bundleForSymbolicName(afterName);
        if (before != null && after != null && before.classpathOrder > after.classpathOrder) {
            this.logger.error("It is a known problem for {} {} to be earlier on the classpath than {} {} because {}", new Object[]{afterName, after.getJarUrl(), beforeName, before.getJarUrl(), reason});
        }
    }

    public List<String> bundlesOnClasspathOutOf(Collection<String> symbolicNames) {
        ArrayList<String> onlyPresent = new ArrayList<String>();
        for (SolsticeManifest bundle : this.bundles) {
            if (!symbolicNames.contains(bundle.getSymbolicName())) continue;
            onlyPresent.add(bundle.getSymbolicName());
        }
        return onlyPresent;
    }

    public Map<String, List<SolsticeManifest>> bySymbolicName() {
        return this.groupBundlesIncludeFragments(true, manifest -> Collections.singletonList(manifest.getSymbolicName()));
    }

    public Map<String, List<SolsticeManifest>> byExportedPackage() {
        return this.groupBundlesIncludeFragments(false, SolsticeManifest::totalPkgExports);
    }

    public Map<String, List<SolsticeManifest>> calculateMissingBundles(Set<String> available) {
        return this.calculateMissingNoFragments(available, SolsticeManifest::totalRequiredBundles);
    }

    public Map<String, List<SolsticeManifest>> calculateMissingPackages(Set<String> available) {
        return this.calculateMissingNoFragments(available, SolsticeManifest::totalPkgImports);
    }

    private Map<String, List<SolsticeManifest>> calculateMissingNoFragments(Set<String> available, Function<SolsticeManifest, List<String>> neededFunc) {
        TreeMap<String, List<SolsticeManifest>> map = new TreeMap<String, List<SolsticeManifest>>();
        for (SolsticeManifest bundle : this.bundles) {
            if (bundle.isFragment()) continue;
            for (String needed : neededFunc.apply(bundle)) {
                if (available.contains(needed)) continue;
                Solstice.mapAdd(map, needed, bundle);
            }
        }
        return map;
    }

    private Map<String, List<SolsticeManifest>> groupBundlesIncludeFragments(boolean includeFragments, Function<SolsticeManifest, List<String>> groupBy) {
        TreeMap<String, List<SolsticeManifest>> map = new TreeMap<String, List<SolsticeManifest>>();
        for (SolsticeManifest bundle : this.bundles) {
            if (!includeFragments && bundle.isFragment()) continue;
            for (String extracted : groupBy.apply(bundle)) {
                Solstice.mapAdd(map, extracted, bundle);
            }
        }
        return map;
    }

    private static <K> void mapAdd(Map<K, List<SolsticeManifest>> map, K key, SolsticeManifest value) {
        List<SolsticeManifest> oldValue = map.putIfAbsent(key, Collections.singletonList(value));
        if (oldValue != null) {
            if (oldValue.size() == 1) {
                ArrayList<SolsticeManifest> newList = new ArrayList<SolsticeManifest>(2);
                newList.addAll(oldValue);
                oldValue = newList;
                map.put(key, newList);
            }
            oldValue.add(value);
        }
    }

    public void warnAndModifyManifestsToFix() {
        Logger logger = LoggerFactory.getLogger(Solstice.class);
        this.warnAndModifyManifestsToFix(logger);
    }

    public void warnAndModifyManifestsToFix(Logger logger) {
        Map<String, List<SolsticeManifest>> bySymbolicName = this.bySymbolicName();
        Map<String, List<String>> missingMap = Solstice.knownMissingBundleDependencies();
        for (Map.Entry<String, List<String>> entry : missingMap.entrySet()) {
            List<SolsticeManifest> inSystem = bySymbolicName.get(entry.getKey());
            if (inSystem == null) continue;
            for (SolsticeManifest solsticeManifest : inSystem) {
                for (String missing2 : entry.getValue()) {
                    if (solsticeManifest.requiredBundles.contains(missing2)) continue;
                    logger.info("Modifying " + solsticeManifest.getSymbolicName() + " to add required bundle " + missing2);
                    solsticeManifest.requiredBundles.add(missing2);
                }
            }
        }
        Map<String, List<SolsticeManifest>> byExportedPackage = this.byExportedPackage();
        bySymbolicName.forEach((symbolicName, manifests) -> {
            if (manifests.size() > 1) {
                logger.warn("Multiple bundles with the same symbolic name: " + symbolicName);
                for (SolsticeManifest manifest : manifests) {
                    logger.warn("  - " + manifest.getJarUrl());
                }
            }
        });
        byExportedPackage.forEach((pkg, manifests) -> {
            if (pkg.startsWith("META-INF.versions.")) {
                return;
            }
            if (manifests.size() > 1) {
                int okayToExport = 1;
                for (SolsticeManifest manifest : manifests) {
                    if (!this.pkgExportIsNotDuplicate((String)pkg, manifest, (List<SolsticeManifest>)manifests)) continue;
                    ++okayToExport;
                }
                if (manifests.size() > okayToExport) {
                    logger.warn("Multiple bundles exporting the same package: " + pkg);
                    for (SolsticeManifest manifest : manifests) {
                        logger.warn("  - " + manifest.getJarUrl());
                    }
                }
            }
        });
        Map<String, List<SolsticeManifest>> missingBundles = this.calculateMissingBundles(bySymbolicName.keySet());
        missingBundles.forEach((missing, neededBy) -> logger.warn("Missing required bundle " + missing + " needed by " + neededBy));
        Map<String, List<SolsticeManifest>> missingPackages = this.calculateMissingPackages(byExportedPackage.keySet());
        missingPackages.forEach((missing, neededBy) -> {
            if (missing.equals("kotlin") || missing.startsWith("kotlin.")) {
                return;
            }
            if (missing.startsWith("javax.") || missing.startsWith("java.")) {
                return;
            }
            if (missing.startsWith("org.xml.") || missing.startsWith("org.w3c.")) {
                return;
            }
            logger.warn("Missing imported package " + missing + " needed by " + neededBy);
        });
        for (SolsticeManifest solsticeManifest : this.bundles) {
            solsticeManifest.removeFromRequiredBundles(missingBundles.keySet());
            solsticeManifest.removeFromPkgImports(missingPackages.keySet());
        }
        Capability.SupersetSet allCapabilities = new Capability.SupersetSet();
        for (SolsticeManifest bundle : this.bundles) {
            allCapabilities.addAll(bundle.capProvides);
        }
        TreeSet<Capability> treeSet = new TreeSet<Capability>();
        for (SolsticeManifest bundle : this.bundles) {
            for (Capability cap : bundle.capRequires) {
                if (allCapabilities.containsAnySupersetOf(cap)) continue;
                logger.warn("Missing required capability " + cap + " needed by " + bundle);
                treeSet.add(cap);
            }
        }
        for (SolsticeManifest bundle : this.bundles) {
            bundle.removeRequiredCapabilities(treeSet);
        }
    }

    private boolean pkgExportIsNotDuplicate(String pkg, SolsticeManifest thisManifest, List<SolsticeManifest> allManifestsForPkg) {
        if (thisManifest.totalPkgImports().contains(pkg)) {
            return true;
        }
        ManifestElement element = thisManifest.pkgExportsRaw().stream().filter(e -> e.getValue().equals(pkg)).findFirst().get();
        String mandatory = element.getDirective("mandatory");
        if (mandatory != null && "split".equals(element.getAttribute(mandatory))) {
            return true;
        }
        String uses = element.getDirective("uses");
        if (uses != null) {
            return true;
        }
        String friends = element.getDirective("x-friends");
        if (friends != null) {
            for (String friend : friends.split(",")) {
                for (SolsticeManifest otherManifest : allManifestsForPkg) {
                    if (otherManifest == thisManifest || !otherManifest.getSymbolicName().equals(friend)) continue;
                    return true;
                }
            }
        }
        return !NestedJars.onClassPath().isNestedJar(thisManifest);
    }

    private void assertContextInitialized(boolean isInitialized) {
        if (isInitialized) {
            if (this.context == null) {
                throw new IllegalStateException("Call `openAtomos` or `openShim` first");
            }
        } else if (this.context != null) {
            throw new IllegalStateException("`openAtomos` or `openShim` can only be called once");
        }
    }

    public void openAtomos(Map<String, String> props) throws BundleException {
        SolsticeFrameworkUtilHelper.initialize(this);
        this.assertContextInitialized(false);
        this.context = BundleContextAtomos.hydrate(this, props);
    }

    public void openShim(Map<String, String> props) {
        SolsticeFrameworkUtilHelper.initialize(this);
        this.assertContextInitialized(false);
        this.context = BundleContextShim.hydrate(this, props);
    }

    public BundleContext getContext() {
        this.assertContextInitialized(true);
        return this.context;
    }

    void hydrateFrom(Function<SolsticeManifest, Bundle> bundleCreator) {
        for (SolsticeManifest bundle : this.bundles) {
            bundle.hydrated = bundleCreator.apply(bundle);
        }
    }

    public void startAllWithLazy(boolean lazyValue) {
        for (SolsticeManifest solstice : this.bundles) {
            if (solstice.isFragment() || solstice.lazy != lazyValue) continue;
            this.start(solstice);
        }
    }

    public void start(String symbolicName) {
        this.start(symbolicName, true);
    }

    public void startWithoutTransitives(String symbolicName) {
        this.start(symbolicName, false);
    }

    private void start(String symbolicName, boolean withTransitives) {
        int numStarted = 0;
        for (SolsticeManifest bundle : this.bundles) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            ++numStarted;
            this.start(bundle, withTransitives);
        }
        if (numStarted == 0) {
            throw new IllegalArgumentException("Cannot start because no bundle with name " + symbolicName);
        }
    }

    private void start(SolsticeManifest manifest) {
        this.start(manifest, true);
    }

    private void start(SolsticeManifest manifest, boolean withTransitives) {
        block12: {
            boolean newAddition = this.activatingBundles.add(manifest);
            if (!newAddition) {
                return;
            }
            this.logger.info("prepare {}", (Object)manifest);
            this.pkgs.addAll(manifest.totalPkgExports());
            this.caps.addAll(manifest.capProvides);
            if (withTransitives) {
                Capability cap;
                String pkg;
                while ((pkg = this.missingPkg(manifest)) != null) {
                    List<SolsticeManifest> bundles = this.unactivatedBundlesForPkg(pkg);
                    if (bundles.isEmpty()) {
                        throw new IllegalArgumentException(manifest + " imports missing package " + pkg);
                    }
                    for (SolsticeManifest solsticeManifest : bundles) {
                        this.start(solsticeManifest);
                    }
                }
                while ((cap = this.missingCap(manifest)) != null) {
                    List<SolsticeManifest> bundles = this.unactivatedBundlesForCap(cap);
                    if (bundles.isEmpty()) {
                        throw new IllegalArgumentException(manifest + " requires missing capability " + cap);
                    }
                    for (SolsticeManifest bundle : bundles) {
                        this.start(bundle);
                    }
                }
                for (String string : manifest.totalRequiredBundles()) {
                    SolsticeManifest bundle;
                    bundle = this.bundleForSymbolicName(string);
                    if (bundle == null) {
                        throw new IllegalArgumentException(manifest + " required missing bundle " + string);
                    }
                    this.start(bundle);
                }
            }
            try {
                this.logger.info("activate {}", (Object)manifest);
                manifest.hydrated.start();
            }
            catch (Exception e) {
                this.logger.warn("error in " + manifest, (Throwable)e);
                if (!Unchecked.anyMatches(e, t -> t instanceof SecurityException && t.getMessage().contains("signer information"))) break block12;
                this.logger.warn("to resolve a signing problem, take a look at https://github.com/equodev/equo-ide/blob/main/solstice/src/main/java/dev/equo/solstice/SignedJars.java");
            }
        }
    }

    private Capability missingCap(SolsticeManifest manifest) {
        for (Capability cap : manifest.capRequires) {
            if (this.caps.containsAnySupersetOf(cap)) continue;
            return cap;
        }
        return null;
    }

    private List<SolsticeManifest> unactivatedBundlesForCap(Capability targetCap) {
        Object bundlesForCap = null;
        for (SolsticeManifest bundle : this.bundles) {
            if (bundle.isFragment() || this.activatingBundles.contains(bundle) || !targetCap.isSubsetOfElementIn(bundle.capProvides)) continue;
            bundlesForCap = this.fastAdd(bundlesForCap, bundle);
        }
        return this.fastAddGet(bundlesForCap);
    }

    private String missingPkg(SolsticeManifest manifest) {
        for (String pkg : manifest.totalPkgImports()) {
            if (this.pkgs.contains(pkg)) continue;
            return pkg;
        }
        return null;
    }

    private List<SolsticeManifest> unactivatedBundlesForPkg(String targetPkg) {
        Object bundlesForPkg = null;
        for (SolsticeManifest bundle : this.bundles) {
            if (bundle.isFragment() || this.activatingBundles.contains(bundle) || !bundle.totalPkgExports().contains(targetPkg)) continue;
            bundlesForPkg = this.fastAdd(bundlesForPkg, bundle);
        }
        return this.fastAddGet(bundlesForPkg);
    }

    private Object fastAdd(Object currentValue, SolsticeManifest toAdd) {
        if (currentValue == null) {
            return toAdd;
        }
        if (currentValue instanceof ArrayList) {
            ((ArrayList)currentValue).add(toAdd);
            return currentValue;
        }
        ArrayList<SolsticeManifest> list = new ArrayList<SolsticeManifest>();
        list.add((SolsticeManifest)currentValue);
        list.add(toAdd);
        return list;
    }

    private List<SolsticeManifest> fastAddGet(Object currentValue) {
        if (currentValue == null) {
            return Collections.emptyList();
        }
        if (currentValue instanceof ArrayList) {
            return (ArrayList)currentValue;
        }
        return Collections.singletonList((SolsticeManifest)currentValue);
    }

    SolsticeManifest bundleForSymbolicName(String name) {
        for (SolsticeManifest bundle : this.bundles) {
            if (!name.equals(bundle.getSymbolicName())) continue;
            return bundle;
        }
        return null;
    }

    SolsticeManifest bundleForUrl(URL source) {
        String sourceString = "jar:" + source.toExternalForm() + "!";
        for (SolsticeManifest bundle : this.bundles) {
            if (!sourceString.equals(bundle.getJarUrl())) continue;
            return bundle;
        }
        return null;
    }
}

