/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.FileMisc;
import dev.equo.solstice.SerializableMisc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class IdeLockFile {
    private final File workspaceDir;
    private static final String CLASSPATH_FILENAME = "classpath";
    private static final String PID_FILENAME = "pid";
    private static final long NO_TOKEN_FILE = -1L;

    private IdeLockFile(File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public static IdeLockFile forWorkspaceDir(File workspaceDir) {
        return new IdeLockFile(workspaceDir);
    }

    void writeClasspath(@Nullable ArrayList<File> files) {
        if (files == null) {
            FileMisc.delete(new File(this.workspaceDir, CLASSPATH_FILENAME));
        } else {
            SerializableMisc.toFile(files, new File(this.workspaceDir, CLASSPATH_FILENAME));
        }
    }

    public boolean hasClasspath() {
        return new File(this.workspaceDir, CLASSPATH_FILENAME).exists();
    }

    public ArrayList<File> readClasspath() {
        return SerializableMisc.fromFile(ArrayList.class, new File(this.workspaceDir, CLASSPATH_FILENAME));
    }

    void savePid() {
        this.writePidToken(ProcessHandle.current().pid());
    }

    private void writePidToken(long pid) {
        if (pid == -1L) {
            FileMisc.delete(new File(this.workspaceDir, PID_FILENAME));
        } else {
            FileMisc.writeToken(this.workspaceDir, PID_FILENAME, Long.toString(pid));
        }
    }

    long readPidToken() {
        return FileMisc.readToken(this.workspaceDir, PID_FILENAME).filter(str -> !str.isEmpty()).map(Long::parseLong).orElse(-1L);
    }

    @Nullable
    public ProcessHandle ideAlreadyRunning() {
        long running = this.readPidToken();
        if (running == -1L) {
            return null;
        }
        ProcessHandle alreadyRunning = ProcessHandle.allProcesses().filter(processHandle -> processHandle.pid() == running).findAny().orElse(null);
        if (alreadyRunning == null) {
            this.writePidToken(-1L);
            return null;
        }
        return alreadyRunning;
    }

    public static boolean alreadyRunningAndUserRequestsAbort(ProcessHandle running) throws IOException, InterruptedException {
        if (running == null) {
            return false;
        }
        System.out.println("There is already an IDE running with PID " + running.pid());
        System.out.println("Shut it down yourself or press");
        System.out.println("  (k + enter) to kill it");
        System.out.println("  (a + enter) to abort");
        while (running.isAlive()) {
            Thread.sleep(10L);
            if (System.in.available() <= 0) continue;
            char c = Character.toLowerCase((char)System.in.read());
            if (c == 'k') {
                System.out.println();
                System.out.println("Attempting to kill " + running.pid() + "...");
                running.destroyForcibly();
                continue;
            }
            if (c != 'a') continue;
            return true;
        }
        System.out.println("The duplicate IDE has shut down. Starting a new one...");
        return false;
    }
}

